/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util.concurrent;

import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class BlockingQueueAdapter<E>
implements BlockingQueue<E> {
    private final Queue<E> delegate;
    private final ConcurrentLinkedDeque<AtomicReference<Thread>> awaiting = new ConcurrentLinkedDeque();

    public BlockingQueueAdapter(Queue<E> delegate) {
        this.delegate = Objects.requireNonNull(delegate, "null delegate");
    }

    @Override
    public E remove() {
        return this.delegate.remove();
    }

    @Override
    public E poll() {
        return this.delegate.poll();
    }

    @Override
    public E element() {
        return this.delegate.element();
    }

    @Override
    public E peek() {
        return this.delegate.peek();
    }

    @Override
    public boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.delegate.removeIf(filter);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.delegate.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.delegate.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.delegate.parallelStream();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.delegate.forEach(action);
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.delegate.toArray(generator);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        E value;
        int i;
        Objects.requireNonNull(c, "null target");
        for (i = 0; i < maxElements && (value = this.poll()) != null; ++i) {
            c.add(value);
        }
        return i;
    }

    @Override
    public void put(E value) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean offer(E value, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E value) {
        return this.offer(value);
    }

    @Override
    public boolean offer(E value) {
        if (this.delegate.offer(Objects.requireNonNull(value, "null value"))) {
            this.signal();
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = false;
        for (E value : c) {
            result |= this.add(value);
        }
        return result;
    }

    @Override
    public E take() throws InterruptedException {
        return this.poll(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        E value = this.poll();
        return value == null ? this.pollInternal(timeout, unit) : value;
    }

    private E pollInternal(long timeout, TimeUnit unit) throws InterruptedException {
        E value;
        long deadlineMs;
        Objects.requireNonNull(unit, "null unit");
        Thread thread = Thread.currentThread();
        AtomicReference<Thread> parker = new AtomicReference<Thread>(thread);
        this.awaiting.push(parker);
        long l = deadlineMs = timeout == Long.MAX_VALUE ? Long.MAX_VALUE : System.currentTimeMillis() + unit.toMillis(timeout);
        do {
            if ((value = this.poll()) != null) continue;
            if (timeout == Long.MAX_VALUE) {
                LockSupport.park(this);
            } else {
                LockSupport.parkUntil(this, deadlineMs);
            }
            value = this.poll();
            if (value != null) continue;
            if (Thread.interrupted()) {
                this.unwait(thread, parker);
                throw new InterruptedException();
            }
            if (timeout != Long.MAX_VALUE && System.currentTimeMillis() >= deadlineMs) {
                this.unwait(thread, parker);
                return null;
            }
            if (parker.get() != null) continue;
            parker = new AtomicReference<Thread>(thread);
            this.awaiting.push(parker);
        } while (value == null);
        if (parker.get() == thread && !parker.compareAndSet(thread, null)) {
            this.signal();
        }
        return value;
    }

    private void unwait(Thread thread, AtomicReference<Thread> parker) {
        if (parker.compareAndSet(thread, null)) {
            this.awaiting.remove(parker);
        } else {
            this.signal();
        }
    }

    private void signal() {
        AtomicReference<Thread> parker = this.awaiting.poll();
        while (parker != null) {
            Thread thread = parker.getAndSet(null);
            if (thread != null) {
                LockSupport.unpark(thread);
                return;
            }
            parker = this.awaiting.poll();
        }
    }
}

