/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util.converter;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.xvm.util.converter.AbstractConverterIterator;

public abstract class AbstractConverterCollection<V, SV>
implements Collection<V> {
    private final Collection<SV> storage;

    protected AbstractConverterCollection(Collection<SV> storage) {
        this.storage = storage;
    }

    protected Collection<SV> read() {
        return this.storage;
    }

    protected Collection<SV> write() {
        return this.storage;
    }

    protected abstract V valueUp(SV var1);

    protected abstract SV valueDown(V var1);

    protected <X, Y extends X> Y unchecked(X x) {
        return (Y)x;
    }

    @Override
    public int size() {
        return this.read().size();
    }

    @Override
    public boolean isEmpty() {
        return this.read().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.read().contains(this.valueDown(this.unchecked(o)));
    }

    @Override
    public Iterator<V> iterator() {
        return new AbstractConverterIterator<V, SV>(this.read().iterator()){

            @Override
            protected V valueUp(SV value) {
                return AbstractConverterCollection.this.valueUp(value);
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] values = this.read().toArray();
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.valueUp(this.unchecked(values[i]));
        }
        return values;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Object[] values = this.toArray();
        if (values.length > a.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), values.length);
        }
        for (int i = 0; i < values.length; ++i) {
            a[i] = values[i];
        }
        return a;
    }

    @Override
    public boolean add(V v) {
        return this.write().add(this.valueDown(v));
    }

    @Override
    public boolean remove(Object o) {
        return this.write().remove(this.valueDown(this.unchecked(o)));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object value : c) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean result = false;
        for (V value : c) {
            result |= this.add(value);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object value : c) {
            result |= this.remove(value);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.write().retainAll(new AbstractConverterCollection<SV, V>(c){

            @Override
            protected SV valueUp(V value) {
                return AbstractConverterCollection.this.valueDown(value);
            }

            @Override
            protected V valueDown(SV value) {
                return AbstractConverterCollection.this.valueUp(value);
            }
        });
    }

    @Override
    public void clear() {
        this.write().clear();
    }
}

