/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.util.converter;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.xvm.util.converter.AbstractConverterCollection;
import org.xvm.util.converter.AbstractConverterEntry;
import org.xvm.util.converter.AbstractConverterSet;

public abstract class AbstractConverterMap<K, V, SK, SV>
implements Map<K, V> {
    private final Map<SK, SV> storage;
    protected final Set<K> keys;
    protected final Collection<V> values;
    protected final Set<Map.Entry<K, V>> entries;

    protected AbstractConverterMap(Map<SK, SV> storage) {
        this.storage = storage;
        this.keys = this.newKeySet();
        this.values = this.newValues();
        this.entries = this.newEntrySet();
    }

    protected Map<SK, SV> read() {
        return this.storage;
    }

    protected Map<SK, SV> write() {
        return this.storage;
    }

    protected abstract SK keyDown(K var1);

    protected abstract K keyUp(SK var1);

    protected abstract SV valueDown(V var1);

    protected abstract V valueUp(SV var1);

    protected <X, Y extends X> Y unchecked(X x) {
        return (Y)x;
    }

    protected Set<K> newKeySet() {
        return new KeySet();
    }

    protected Collection<V> newValues() {
        return new Values();
    }

    protected Set<Map.Entry<K, V>> newEntrySet() {
        return new EntrySet();
    }

    @Override
    public int size() {
        return this.read().size();
    }

    @Override
    public boolean isEmpty() {
        return this.read().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.read().containsKey(this.keyDown(this.unchecked(key)));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.read().containsValue(this.valueDown(this.unchecked(value)));
    }

    @Override
    public V get(Object key) {
        return this.valueUp(this.read().get(this.keyDown(this.unchecked(key))));
    }

    @Override
    public V put(K key, V value) {
        return this.valueUp(this.write().put(this.keyDown(key), this.valueDown(value)));
    }

    @Override
    public V remove(Object key) {
        return this.valueUp(this.write().remove(this.keyDown(this.unchecked(key))));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        Map<SK, SV> storage = this.write();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            storage.put(this.keyDown(entry.getKey()), this.valueDown(entry.getValue()));
        }
    }

    @Override
    public void clear() {
        this.write().clear();
    }

    @Override
    public Set<K> keySet() {
        return this.keys;
    }

    @Override
    public Collection<V> values() {
        return this.values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entries;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        this.write().replaceAll((k, v) -> this.valueDown(function.apply((K)this.keyUp(k), (V)this.valueUp(v))));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.valueUp(this.write().putIfAbsent(this.keyDown(key), this.valueDown(value)));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.write().remove(this.keyDown(this.unchecked(key)), this.valueDown(this.unchecked(value)));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.write().replace(this.keyDown(key), this.valueDown(oldValue), this.valueDown(newValue));
    }

    @Override
    public V replace(K key, V value) {
        return this.valueUp(this.write().replace(this.keyDown(key), this.valueDown(value)));
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        return this.valueUp(this.write().computeIfAbsent(this.keyDown(key), k -> this.valueDown(mappingFunction.apply((K)key))));
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.valueUp(this.write().computeIfPresent(this.keyDown(key), (k, v) -> this.valueDown(remappingFunction.apply((K)key, (V)this.valueUp(v)))));
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        return this.valueUp(this.write().compute(this.keyDown(key), (k, v) -> this.valueDown(remappingFunction.apply((K)key, (V)this.valueUp(v)))));
    }

    @Override
    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        return this.valueUp(this.write().merge(this.keyDown(key), this.valueDown(value), (v1, v2) -> this.valueDown(remappingFunction.apply((V)this.valueUp(v1), (V)this.valueUp(v2)))));
    }

    protected class KeySet
    extends AbstractConverterSet<K, SK> {
        protected KeySet() {
            super(AbstractConverterMap.this.storage.keySet());
        }

        @Override
        protected Collection<SK> read() {
            AbstractConverterMap.this.read();
            return super.read();
        }

        @Override
        protected Collection<SK> write() {
            AbstractConverterMap.this.write();
            return super.write();
        }

        @Override
        protected K valueUp(SK value) {
            return AbstractConverterMap.this.keyUp(value);
        }

        @Override
        protected SK valueDown(K value) {
            return AbstractConverterMap.this.keyDown(value);
        }
    }

    protected class Values
    extends AbstractConverterCollection<V, SV> {
        protected Values() {
            super(AbstractConverterMap.this.storage.values());
        }

        @Override
        protected Collection<SV> read() {
            AbstractConverterMap.this.read();
            return super.read();
        }

        @Override
        protected Collection<SV> write() {
            AbstractConverterMap.this.write();
            return super.write();
        }

        @Override
        protected V valueUp(SV value) {
            return AbstractConverterMap.this.valueUp(value);
        }

        @Override
        protected SV valueDown(V value) {
            return AbstractConverterMap.this.valueDown(value);
        }
    }

    protected class EntrySet
    extends AbstractConverterSet<Map.Entry<K, V>, Map.Entry<SK, SV>> {
        protected EntrySet() {
            super(AbstractConverterMap.this.storage.entrySet());
        }

        @Override
        protected Collection<Map.Entry<SK, SV>> read() {
            AbstractConverterMap.this.read();
            return super.read();
        }

        @Override
        protected Collection<Map.Entry<SK, SV>> write() {
            AbstractConverterMap.this.write();
            return super.write();
        }

        @Override
        protected Map.Entry<K, V> valueUp(Map.Entry<SK, SV> value) {
            return new AbstractConverterEntry<K, V, SK, SV>(value){

                @Override
                protected K keyUp(SK key) {
                    return AbstractConverterMap.this.keyUp(key);
                }

                @Override
                protected SV valueDown(V value) {
                    return AbstractConverterMap.this.valueDown(value);
                }

                @Override
                protected V valueUp(SV value) {
                    return AbstractConverterMap.this.valueUp(value);
                }
            };
        }

        @Override
        protected Map.Entry<SK, SV> valueDown(Map.Entry<K, V> value) {
            return new AbstractConverterEntry<SK, SV, K, V>(value){

                @Override
                protected SK keyUp(K key) {
                    return AbstractConverterMap.this.keyDown(key);
                }

                @Override
                protected V valueDown(SV value) {
                    return AbstractConverterMap.this.valueUp(value);
                }

                @Override
                protected SV valueUp(V value) {
                    return AbstractConverterMap.this.valueDown(value);
                }
            };
        }
    }
}

