/*
 * Decompiled with CFR 0.152.
 */
package org.xtclang.ecstasy.numbers;

import org.xtclang.ecstasy.Exception;
import org.xtclang.ecstasy.xConst;

public class Int64
extends xConst {
    public final long $value;
    private static final int SMALL_CACHE_OFFSET = 512;
    private static final int SMALL_CACHE_SIZE = 8192;
    private static final Int64[] SMALL_CACHE = new Int64[8192];
    public static final Int64 ZERO = Int64.$box(0L);
    public static final Int64 ONE = Int64.$box(1L);
    public static final Int64 NEG_ONE = Int64.$box(-1L);
    public static final Int64 MIN = Int64.$box(Long.MIN_VALUE);
    public static final Int64 MAX = Int64.$box(Long.MAX_VALUE);

    public Int64(long value) {
        super(null);
        this.$value = value;
    }

    public static Int64 $box(long value) {
        long key = value + 512L;
        if ((key & 0xFFFFFFFFFFFFE000L) == 0L) {
            Int64 ref = SMALL_CACHE[(int)key];
            if (ref == null) {
                Int64.SMALL_CACHE[(int)key] = ref = new Int64(value);
            }
            return ref;
        }
        return new Int64(value);
    }

    public static long $next(long n) {
        if (n == Long.MAX_VALUE) {
            throw Exception.$oob("64-bit max value exceeded", null);
        }
        return n + 1L;
    }

    public static long $prev(long n) {
        if (n == Long.MIN_VALUE) {
            throw Exception.$oob("64-bit min value exceeded", null);
        }
        return n - 1L;
    }

    public String toString() {
        return "Int64:" + this.$value;
    }
}

