/*
 * Decompiled with CFR 0.152.
 */
package org.xtclang.ecstasy.text;

import org.xtclang.ecstasy.xConst;
import org.xvm.javajit.Ctx;
import org.xvm.util.Handy;

public class String
extends xConst {
    private long[] data;
    private int start;
    private int end;
    private final String next;
    private boolean unicode;
    private long hash;
    public static final String EmptyString = new String(null, new long[0], true, 0L, 0, 0, null);

    public String(Ctx ctx, java.lang.String s) {
        super(ctx);
        Handy.require((java.lang.String)"s", (Object)s);
        this.next = null;
        if (s.isEmpty()) {
            this.data = String.EmptyString.data;
            return;
        }
        int utf16len = s.length();
        int pairs = 0;
        for (int i = 0; i < utf16len; ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u00ff') continue;
            this.unicode = true;
            if (ch < '\ud800') continue;
            if (ch <= '\udbff') {
                char low;
                if (i == utf16len - 1) {
                    throw new IllegalArgumentException("The string ends with codepoint 0x" + Integer.toString(ch, 16) + ", which is the first half of a surrogate pair");
                }
                if ((low = s.charAt(++i)) < '\udc00' || low > '\udfff') {
                    throw new IllegalArgumentException("Character 0x" + Integer.toString(low, 16) + " at offset " + i + " follows the high surrogate 0x" + Integer.toString(ch, 16) + ", but is not a low surrogate");
                }
                ++pairs;
                continue;
            }
            if (ch >= '\udfff') continue;
            throw new IllegalArgumentException("Character 0x" + Integer.toString(ch, 16) + " at offset " + i + " is a low surrogate, but does not follow a high surrogate");
        }
        if (this.unicode) {
            int unicodeLen = utf16len - pairs;
            this.data = new long[(unicodeLen + 2) / 3];
            int packed = 0;
            int dest = 0;
            long tri = 0L;
            for (int src = 0; src < utf16len; ++src) {
                int utf16 = s.charAt(src);
                int uni21 = utf16 < 55296 || utf16 > 56319 ? utf16 : Character.toCodePoint((char)utf16, s.charAt(++src));
                tri = tri << 21 | (long)uni21;
                if (++packed != 3) continue;
                this.data[dest++] = tri;
                tri = 0L;
                packed = 0;
            }
            if (tri != 0L) {
                this.data[dest] = tri << 21 * (3 - packed);
            }
            this.end = unicodeLen;
        } else {
            this.data = new long[utf16len + 7 >>> 3];
            long octo = 0L;
            for (int src = 0; src < utf16len; ++src) {
                char ch = s.charAt(src);
                octo = octo << 8 | (long)ch;
                if ((src & 7) != 7) continue;
                this.data[src >>> 3] = octo;
                octo = 0L;
            }
            if (octo != 0L) {
                int last = utf16len - 1;
                this.data[last >>> 3] = octo << (~(last & 7) << 3);
            }
            this.end = utf16len;
        }
    }

    public String(Ctx ctx, byte[] utf8) {
        this(ctx, null, false, 0L, 0, 0, null);
    }

    String(Ctx ctx, long[] data, boolean unicode, long hash, int start, int end, String next) {
        super(ctx);
        this.data = data;
        this.unicode = unicode;
        this.hash = hash;
        this.start = start;
        this.end = end;
        this.next = next;
    }

    public boolean empty() {
        return this.start == this.end;
    }

    public long size() {
        return (long)(this.end - this.start) + (this.next == null ? 0L : this.next.size());
    }

    public long utf16Size() {
        long localSize = this.end - this.start;
        if (this.unicode && localSize > 0L) {
            int next = this.start / 3;
            long tri = this.data[next++];
            int shift = (2 - this.start % 3) * 21;
            for (int c = this.end - this.start; c > 0; --c) {
                if (shift < 0) {
                    tri = this.data[next++];
                    shift = 42;
                }
                if ((tri >>> shift & 0x1FFFFFL) > 65535L) {
                    ++localSize;
                }
                shift -= 21;
            }
        }
        return localSize + (this.next == null ? 0L : this.next.utf16Size());
    }

    public int get(long index) {
        if (index < 0L) {
            this.oob(index);
        }
        return this.getContinued(0L, index);
    }

    private int getContinued(long skipped, long index) {
        int len = this.end - this.start;
        if (index > (long)len) {
            if (this.next == null) {
                this.oob(skipped + index);
            }
            return this.next.getContinued(skipped + (long)len, index - (long)len);
        }
        index += (long)this.start;
        if (this.unicode) {
            long tri = this.data[(int)((index *= 0x55555556L) >>> 32)];
            return (int)(tri >>> 21 * (2 - (int)((index & 0xFFFFFFFFL) * 3L >>> 32))) & 0x1FFFFF;
        }
        return (int)(this.data[(int)(index >>> 3)] >>> (int)(8L * ((index ^ 0xFFFFFFFFFFFFFFFFL) & 7L))) & 0xFF;
    }

    public java.lang.String toString() {
        long len = this.size();
        if (len == 0L) {
            return "";
        }
        if (len > 0x7FFFFFF7L) {
            this.oob(len);
        }
        return this.toStringContinued(new StringBuilder((int)this.utf16Size())).toString();
    }

    public static String of(Ctx ctx, java.lang.String s) {
        return new String(ctx, s);
    }

    private StringBuilder toStringContinued(StringBuilder buf) {
        if (this.unicode) {
            int index = this.start / 3;
            long tri = this.data[index];
            int shift = (2 - this.start % 3) * 21;
            for (int c = this.end - this.start; c > 0; --c) {
                if (shift < 0) {
                    tri = this.data[++index];
                    shift = 42;
                }
                buf.appendCodePoint((int)(tri >>> shift & 0x1FFFFFL));
                shift -= 21;
            }
        } else {
            int index = this.start >>> 3;
            long octo = this.data[index];
            int shift = (~this.start & 7) * 8;
            for (int c = this.end - this.start; c > 0; --c) {
                if (shift < 0) {
                    octo = this.data[++index];
                    shift = 56;
                }
                buf.append((char)(octo >>> shift & 0xFFL));
                shift -= 8;
            }
        }
        return this.next == null ? buf : this.next.toStringContinued(buf);
    }

    private boolean oob(long index) {
        if (index >= Integer.MIN_VALUE && index <= Integer.MAX_VALUE) {
            throw new StringIndexOutOfBoundsException((int)index);
        }
        throw new StringIndexOutOfBoundsException(java.lang.String.valueOf(index));
    }
}

