/**
 * This is an extremely basic web server example.
 *
 * To compile and run this example, execute the following command line from the directory containing
 * this file:
 *
 *     xec HelloServer
 *
 * Then, to access the running server, open a browser and enter the following URL:
 *
 *     http://localhost:8080/
 */
@WebApp
module HelloServer {
    package web   import web.xtclang.org;
    package xenia import xenia.xtclang.org;

    import web.*;
    import web.http.*;

    void run() {
        xenia.createServer(this, new HostInfo("localhost", 8080, 8090));

        @Inject Console console;
        console.print($|To access this server, open a browser on this machine and enter this URL:
                       |
                       |     http://localhost:8080/
                       |
                       | Or:
                       |
                       |     https://localhost:8090/
                       |
                       |Use Ctrl-C to stop.
                     );
    }

    @WebService("/")
    service SiteRoot {
        @Get
        String sayHello() = "Hello, World!";
    }
}