/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.xxdc.oss.example.GameBoardLocalImpl;
import org.xxdc.oss.example.JsonSerializable;

public interface GameBoard
extends JsonSerializable {
    public static final System.Logger log = System.getLogger(GameBoard.class.getName());
    public static final AtomicBoolean useNative = new AtomicBoolean(true);

    public boolean isValidMove(int var1);

    default public List<Integer> availableMoves() {
        int d = this.dimension();
        ArrayList<Integer> availableMoves = new ArrayList<Integer>(d * d);
        for (int i = 0; i < d; ++i) {
            for (int j = 0; j < d; ++j) {
                if (!this.isValidMove(i * d + j)) continue;
                availableMoves.add(i * d + j);
            }
        }
        return availableMoves;
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.dimension() * this.dimension(); ++i) {
            if (this.isValidMove(i)) continue;
            return false;
        }
        return true;
    }

    public boolean hasPlayer(String var1, int var2);

    public boolean hasChain(String var1);

    public boolean hasMovesAvailable();

    public GameBoard withMove(String var1, int var2);

    public int dimension();

    @Override
    public String asJsonString();

    public String toString();

    public static GameBoard withDimension(int dimension) {
        GameBoard gameBoard;
        try {
            if (useNative.get()) {
                Class<?> gameBoardNativeImplClass = Class.forName("org.xxdc.oss.example.GameBoardNativeImpl");
                gameBoard = (GameBoard)gameBoardNativeImplClass.getDeclaredConstructor(Integer.TYPE).newInstance(dimension);
            } else {
                gameBoard = new GameBoardLocalImpl(dimension);
            }
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            log.log(System.Logger.Level.WARNING, "Unable to use native game board, falling back to local game board: {0}({1})", e.getClass(), e.getMessage());
            useNative.set(false);
            gameBoard = new GameBoardLocalImpl(dimension);
        }
        return gameBoard;
    }

    public String[] content();
}

