/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.analysis;

import java.util.stream.Gatherer;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.analysis.StrategicTurningPoint;

public class Analyzers {
    public static Gatherer<GameState, GathererState, StrategicTurningPoint> strategicTurningPoints() {
        return Gatherer.ofSequential(GathererState::new, (Gatherer.Integrator)Gatherer.Integrator.of((state, currGameState, downstream) -> {
            if (state.prevGameState != null) {
                StrategicTurningPoint.from(state.prevGameState, currGameState, state.currMoveNumber).ifPresent(arg_0 -> ((Gatherer.Downstream)downstream).push(arg_0));
            }
            return state.add((GameState)currGameState);
        }));
    }

    static class GathererState {
        private GameState prevGameState;
        private int currMoveNumber;

        GathererState() {
        }

        public boolean add(GameState gameState) {
            if (this.prevGameState == null) {
                this.prevGameState = gameState;
                this.currMoveNumber = gameState.board().dimension() * gameState.board().dimension() - gameState.availableMoves().size() + 1;
                return true;
            }
            this.prevGameState = gameState;
            ++this.currMoveNumber;
            return true;
        }
    }
}

