/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.analysis;

import java.util.Optional;
import org.xxdc.oss.example.GameState;

public sealed interface StrategicTurningPoint {
    public String playerMarker();

    public GameState gameState();

    public int moveNumber();

    public PriorityLevel priorityLevel();

    public static boolean moveTakesCenterSquareControl(GameState prevGameState, GameState gameState) {
        if (gameState.board().dimension() % 2 == 0) {
            return false;
        }
        int dimension = gameState.board().dimension();
        int centerLocation = dimension * (dimension / 2) + dimension / 2;
        return prevGameState.board().isValidMove(centerLocation) && !gameState.board().isValidMove(centerLocation);
    }

    public static boolean movePreventedImmediateLoss(GameState prevGameState, GameState gameState) {
        String lastPlayer = gameState.lastPlayer();
        int lastMove = gameState.lastMove();
        if (gameState.availableMoves().isEmpty()) {
            return false;
        }
        return prevGameState.playerMarkers().stream().filter(player -> !player.equals(lastPlayer)).anyMatch(opponent -> prevGameState.board().withMove((String)opponent, lastMove).hasChain((String)opponent));
    }

    public static boolean moveWinsGame(GameState gameState) {
        return gameState.lastPlayerHasChain();
    }

    public static Optional<StrategicTurningPoint> from(GameState prevGameState, GameState gameState, int moveNumber) {
        if (StrategicTurningPoint.moveWinsGame(gameState)) {
            return Optional.of(new GameWon(gameState.lastPlayer(), gameState, moveNumber));
        }
        if (StrategicTurningPoint.moveTakesCenterSquareControl(prevGameState, gameState)) {
            return Optional.of(new CenterSquareControl(gameState.lastPlayer(), gameState, moveNumber));
        }
        if (StrategicTurningPoint.movePreventedImmediateLoss(prevGameState, gameState)) {
            return Optional.of(new ImmediateLossPrevention(gameState.lastPlayer(), gameState, moveNumber));
        }
        return Optional.empty();
    }

    public record GameWon(String playerMarker, GameState gameState, int moveNumber) implements StrategicTurningPoint
    {
        @Override
        public PriorityLevel priorityLevel() {
            return PriorityLevel.HIGH;
        }
    }

    public record CenterSquareControl(String playerMarker, GameState gameState, int moveNumber) implements StrategicTurningPoint
    {
        @Override
        public PriorityLevel priorityLevel() {
            return PriorityLevel.MEDIUM;
        }
    }

    public record ImmediateLossPrevention(String playerMarker, GameState gameState, int moveNumber) implements StrategicTurningPoint
    {
        @Override
        public PriorityLevel priorityLevel() {
            return PriorityLevel.HIGH;
        }
    }

    public static enum PriorityLevel {
        HIGH,
        MEDIUM,
        LOW;

    }
}

