/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.bot;

import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.bot.BotStrategy;
import org.xxdc.oss.example.bot.BotStrategyConfig;

public final class Minimax
implements BotStrategy {
    private static final System.Logger log = System.getLogger(Minimax.class.getName());
    private static final int MIN_SCORE = -100;
    private static final int MAX_SCORE = 100;
    private static final int DRAW_SCORE = 0;
    private final String maximizer;
    private final BotStrategyConfig config;
    private final GameState initialState;

    public Minimax(GameState initialState) {
        this(initialState, BotStrategyConfig.empty());
    }

    public Minimax(GameState initialState, BotStrategyConfig config) {
        this.initialState = initialState;
        this.maximizer = initialState.currentPlayer();
        if (initialState.playerMarkers().size() != 2) {
            throw new IllegalArgumentException("Minimax requires exactly two players");
        }
        this.config = config;
    }

    @Override
    public int bestMove() {
        int bestMove = -1;
        int maxScore = -2147483647;
        for (int move : this.initialState.availableMoves()) {
            GameState newState = this.initialState.afterPlayerMoves(move);
            int score = this.minimax(newState, false, 0);
            this.log(move, score, 0);
            if (score <= maxScore) continue;
            maxScore = score;
            bestMove = move;
        }
        return bestMove;
    }

    private int minimax(GameState state, boolean isMaximizing, int depth) {
        if (state.hasChain(this.maximizer)) {
            return 100 - depth;
        }
        if (state.hasChain(this.opponent(this.maximizer))) {
            return -100 + depth;
        }
        if (!state.hasMovesAvailable() || this.config.exceedsMaxDepth(depth)) {
            return 0;
        }
        if (isMaximizing) {
            int value = -2147483647;
            for (int move : state.availableMoves()) {
                GameState newState = state.afterPlayerMoves(move);
                int score = this.minimax(newState, false, depth + 1);
                value = Math.max(value, score);
            }
            return value;
        }
        int value = Integer.MAX_VALUE;
        for (int move : state.availableMoves()) {
            GameState newState = state.afterPlayerMoves(move);
            int score = this.minimax(newState, true, depth + 1);
            value = Math.min(value, score);
        }
        return value;
    }

    private void log(int location, int score, int depth) {
        String indent = "-".repeat(depth);
        log.log(System.Logger.Level.DEBUG, "{0}{1}: Location: {2} Score: {3}", indent, this.maximizer, location, score);
    }

    private String opponent(String playerMarker) {
        return this.initialState.playerMarkers().stream().dropWhile(playerMarker::equals).findFirst().orElseThrow();
    }
}

