/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.SequencedCollection;
import java.util.UUID;
import java.util.function.Consumer;
import org.xxdc.oss.example.BotPlayer;
import org.xxdc.oss.example.GameBoard;
import org.xxdc.oss.example.GamePersistence;
import org.xxdc.oss.example.GameServiceException;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.HumanPlayer;
import org.xxdc.oss.example.PlayerNode;
import org.xxdc.oss.example.PlayerNodes;

public class Game
implements Serializable,
AutoCloseable {
    private static final System.Logger log = System.getLogger(Game.class.getName());
    private static final long serialVersionUID = 1L;
    private final UUID gameId;
    private final Deque<GameState> gameState;
    private final PlayerNodes playerNodes;
    private final boolean persistenceEnabled;
    private int moveNumber;

    public Game() {
        this(3, true, new PlayerNode.Local<HumanPlayer>("X", new HumanPlayer()), new PlayerNode.Local<BotPlayer>("O", new BotPlayer()));
    }

    public Game(int size, boolean persistenceEnabled, PlayerNode ... players) {
        this.playerNodes = PlayerNodes.of(players);
        this.gameId = UUID.randomUUID();
        this.moveNumber = 0;
        this.gameState = new ArrayDeque<GameState>();
        this.gameState.add(new GameState(GameBoard.withDimension(size), this.playerNodes.playerMarkerList(), 0));
        this.persistenceEnabled = persistenceEnabled;
    }

    public static Game from(File gameFile) throws IOException, ClassNotFoundException {
        GamePersistence persistence = new GamePersistence();
        return persistence.loadFrom(gameFile);
    }

    public static Game ofBots() {
        return new Game(3, false, new PlayerNode.Local<BotPlayer>("X", new BotPlayer()), new PlayerNode.Local<BotPlayer>("O", new BotPlayer()));
    }

    public void play() {
        this.playWithAction(null);
    }

    public void playWithAction(Consumer<Game> postMoveAction) {
        try {
            GamePersistence persistence = new GamePersistence();
            File persistenceDir = this.gameFileDirectory();
            GameState state = this.currentGameState();
            boolean movesAvailable = state.hasMovesAvailable();
            PlayerNode currentPlayer = this.playerNodes.byIndex(state.currentPlayerIndex());
            Optional<String> winningPlayer = this.checkWon(state);
            this.playerNodes.render();
            while (winningPlayer.isEmpty() && movesAvailable) {
                this.renderBoard();
                log.log(System.Logger.Level.DEBUG, "Current Player: {0}", currentPlayer.playerMarker());
                ++this.moveNumber;
                GameState newState = state.afterPlayerMoves(currentPlayer.applyAsInt(state));
                state = this.pushGameState(newState);
                if (this.persistenceEnabled && state.board() instanceof Serializable) {
                    persistence.saveTo(this.gameFile(persistenceDir), this);
                }
                winningPlayer = this.checkWon(state);
                movesAvailable = state.hasMovesAvailable();
                currentPlayer = this.playerNodes.byIndex(state.currentPlayerIndex());
                if (postMoveAction == null) continue;
                postMoveAction.accept(this);
            }
            winningPlayer.ifPresentOrElse(p -> log.log(System.Logger.Level.INFO, "Winner: Player {0}!", p), () -> log.log(System.Logger.Level.INFO, "Tie Game!"));
            this.renderBoard();
            this.close();
        }
        catch (Exception e) {
            throw new GameServiceException("Failure whilst playing game: " + e.getMessage(), e);
        }
    }

    @Deprecated(since="1.5.0", forRemoval=true)
    public UUID getGameId() {
        return this.gameId;
    }

    public UUID id() {
        return this.gameId;
    }

    @Override
    public void close() throws Exception {
        this.playerNodes.close();
    }

    public int numberOfPlayers() {
        return this.playerNodes.playerMarkerList().size();
    }

    public SequencedCollection<GameState> history() {
        return this.gameState;
    }

    public int moveNumber() {
        return this.moveNumber;
    }

    private Optional<String> checkWon(GameState state) {
        return state.lastMove() > -1 && state.lastPlayerHasChain() ? Optional.of(state.playerMarkers().get(state.lastPlayerIndex())) : Optional.empty();
    }

    private File gameFileDirectory() throws IOException {
        return Files.createTempDirectory(String.valueOf(this.gameId), new FileAttribute[0]).toFile();
    }

    private File gameFile(File persistenceDir) {
        return new File(persistenceDir, String.valueOf(this.gameId) + "." + this.moveNumber + ".game");
    }

    private GameState pushGameState(GameState state) {
        this.gameState.add(state);
        return state;
    }

    private void renderBoard() {
        log.log(System.Logger.Level.INFO, "\n" + String.valueOf(this.currentGameState().board()));
    }

    private GameState currentGameState() {
        return this.gameState.peekLast();
    }
}

