/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.io.Serializable;
import java.util.function.ToIntFunction;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.Player;
import org.xxdc.oss.example.transport.TransportConfiguration;
import org.xxdc.oss.example.transport.TransportServer;

public sealed interface PlayerNode
extends ToIntFunction<GameState> {
    public String playerMarker();

    @Override
    public int applyAsInt(GameState var1);

    public static final class Remote
    implements PlayerNode,
    AutoCloseable {
        private static final System.Logger log = System.getLogger(Remote.class.getName());
        private String playerMarker;
        private final TransportServer transport;

        public Remote(String playerMarker, TransportServer transport) {
            this.playerMarker = playerMarker;
            this.transport = transport;
            if (transport == null) {
                throw new IllegalArgumentException("TransportServer cannot be null");
            }
            transport.initialize(new TransportConfiguration(playerMarker));
        }

        @Override
        public int applyAsInt(GameState state) {
            int move = -1;
            do {
                try {
                    log.log(System.Logger.Level.DEBUG, "Sending game state to client: {0}", state);
                    this.transport.send(state);
                    move = this.transport.accept();
                    if (!log.isLoggable(System.Logger.Level.DEBUG)) continue;
                    log.log(System.Logger.Level.DEBUG, "Received move from client: {0}", move);
                    log.log(System.Logger.Level.DEBUG, "Move is valid: {0}", state.board().isValidMove(move));
                }
                catch (NumberFormatException e) {
                    log.log(System.Logger.Level.TRACE, "Invalid move from client: {0}", e.getMessage(), e);
                }
            } while (!state.board().isValidMove(move));
            return move;
        }

        @Override
        public void close() throws Exception {
            this.transport.close();
        }

        @Override
        public String playerMarker() {
            return this.playerMarker;
        }

        public String toString() {
            return "Remote{playerMarker=" + this.playerMarker + ", transport=" + this.transport.getClass().getSimpleName() + "}";
        }
    }

    public static final class Local<P extends Player>
    implements PlayerNode,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final P player;
        private final String playerMarker;

        public Local(String playerMarker, P player) {
            this.playerMarker = playerMarker;
            this.player = player;
        }

        @Override
        public int applyAsInt(GameState state) {
            return this.player.nextMove(state);
        }

        @Override
        public String playerMarker() {
            return this.playerMarker;
        }

        public Player player() {
            return this.player;
        }

        public String toString() {
            return "Local{playerMarker=" + this.playerMarker + ", player=" + String.valueOf(this.player) + "}";
        }
    }
}

