/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.bot;

import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.bot.BotStrategy;
import org.xxdc.oss.example.bot.BotStrategyConfig;

public final class Paranoid
implements BotStrategy {
    private static final System.Logger log = System.getLogger(Paranoid.class.getName());
    private static final int MAX_SCORE = 100;
    private static final int MIN_SCORE = -100;
    private final GameState initialState;
    private final BotStrategyConfig config;

    public Paranoid(GameState initialState) {
        this.initialState = initialState;
        this.config = BotStrategyConfig.empty();
    }

    public Paranoid(GameState initialState, BotStrategyConfig config) {
        this.initialState = initialState;
        this.config = config;
    }

    @Override
    public int bestMove() {
        int bestMove = -1;
        int maxScore = Integer.MIN_VALUE;
        for (int move : this.initialState.board().availableMoves()) {
            GameState newState = this.initialState.afterPlayerMoves(move);
            int score = this.paranoid(newState, 0);
            this.log(move, score, 0);
            System.out.println("Paranoid: " + score);
            if (score <= maxScore) continue;
            maxScore = score;
            bestMove = move;
        }
        return bestMove;
    }

    private int paranoid(GameState state, int depth) {
        if (state.hasChain(this.maximizer())) {
            return 100 - depth;
        }
        if (state.lastPlayerIndex() != this.maximizerIndex() && state.lastPlayerHasChain()) {
            return -100 + depth;
        }
        if (!state.hasMovesAvailable() || this.config.exceedsMaxDepth(depth)) {
            return -100 + depth;
        }
        if (this.maximizerIndex() == state.currentPlayerIndex()) {
            int maxScore = -2147483647;
            for (int move : state.availableMoves()) {
                GameState newState = state.afterPlayerMoves(move);
                int score = this.paranoid(newState, depth + 1);
                maxScore = Math.max(maxScore, score);
            }
            return maxScore;
        }
        int minScore = Integer.MAX_VALUE;
        for (int move : state.availableMoves()) {
            GameState newState = state.afterPlayerMoves(move);
            int score = this.paranoid(newState, depth + 1);
            minScore = Math.min(minScore, score);
        }
        return minScore;
    }

    private String maximizer() {
        return this.initialState.currentPlayer();
    }

    private int maximizerIndex() {
        return this.initialState.currentPlayerIndex();
    }

    private void log(int location, int score, int depth) {
        String indent = "-".repeat(depth);
        log.log(System.Logger.Level.DEBUG, "{0}{1}: Location: {2} Score: {3}", indent, this.maximizer(), location, score);
    }
}

