/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.xxdc.oss.example.GameBoard;
import org.xxdc.oss.example.GameServiceException;
import org.xxdc.oss.example.JsonSerializable;

public record GameState(GameBoard board, List<String> playerMarkers, int currentPlayerIndex, int lastMove) implements JsonSerializable,
Serializable
{
    public GameState(GameBoard board, List<String> playerMarkers, int currentPlayerIndex) {
        this(board, playerMarkers, currentPlayerIndex, -1);
    }

    public GameState(GameState state) {
        this(state.board, new ArrayList<String>(state.playerMarkers), state.currentPlayerIndex, state.lastMove);
    }

    public String currentPlayer() {
        return this.playerMarkers.get(this.currentPlayerIndex);
    }

    public boolean hasMovesAvailable() {
        return this.board.hasMovesAvailable();
    }

    public boolean hasChain(String player) {
        return this.board.hasChain(player);
    }

    public List<Integer> availableMoves() {
        return this.board.availableMoves();
    }

    public boolean isTerminal() {
        if (!this.board.hasMovesAvailable()) {
            return true;
        }
        for (String player : this.playerMarkers) {
            if (!this.board.hasChain(player)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String asJsonString() {
        StringBuilder json = new StringBuilder();
        json.append("{");
        if (this.playerMarkers.size() > 0) {
            json.append("\"playerMarkers\":[\"").append(String.join((CharSequence)"\",\"", this.playerMarkers)).append("\"],");
        } else {
            json.append("\"playerMarkers\":[],");
        }
        json.append("\"currentPlayerIndex\":").append(this.currentPlayerIndex).append(",");
        json.append("\"board\":").append(this.board.asJsonString());
        json.append("}");
        return json.toString();
    }

    public GameState afterPlayerMoves(int move) {
        GameBoard newBoard = this.board.withMove(this.currentPlayer(), move);
        int newCurrentPlayerIndex = (this.currentPlayerIndex + 1) % this.playerMarkers.size();
        return new GameState(newBoard, this.playerMarkers, newCurrentPlayerIndex, move);
    }

    public boolean lastPlayerHasChain() {
        return this.board.hasChain(this.lastPlayer());
    }

    public String lastPlayer() {
        if (this.lastMove < 0 || this.board.isEmpty()) {
            throw new GameServiceException("null last player");
        }
        return this.playerMarkers.get(this.lastPlayerIndex());
    }

    public int lastPlayerIndex() {
        return (this.currentPlayerIndex + this.playerMarkers.size() - 1) % this.playerMarkers.size();
    }
}

