/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.lang.runtime.SwitchBootstraps;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Objects;
import org.xxdc.oss.example.PlayerNode;

public class PlayerPrinter {
    public String getPlayerIdentifier(PlayerNode player) {
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String ipAddress = localHost.getHostAddress();
            String hostName = localHost.getHostName();
            return String.format("TicTacToeClient/1.0 [%s] (IP: %s; Host: %s; Java: %s; OS: %s %s)", this.playerToType(player), ipAddress, hostName, javaVersion, osName, osVersion);
        }
        catch (UnknownHostException unknownHostException) {
            return String.format("TicTacToeClient/1.0 [%s] (IP: unknown; Host: unknown; Java: %s; OS: %s %s)", this.playerToType(player), javaVersion, osName, osVersion);
        }
    }

    private String playerToType(PlayerNode player) {
        PlayerNode playerNode = player;
        Objects.requireNonNull(playerNode);
        PlayerNode playerNode2 = playerNode;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlayerNode.Local.class, PlayerNode.Remote.class}, (PlayerNode)playerNode2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                PlayerNode.Local l = (PlayerNode.Local)playerNode2;
                yield "Local (" + l.playerMarker() + ":" + l.player().getClass().getSimpleName() + ")";
            }
            case 1 -> {
                PlayerNode.Remote r = (PlayerNode.Remote)playerNode2;
                yield "Remote (" + r.playerMarker() + ")";
            }
        };
    }
}

