/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.bot;

import java.util.concurrent.TimeUnit;

public class BotStrategyConfig {
    private Integer maxIterations;
    private Integer maxDepth;
    private Long maxTimeMillis;
    private static final BotStrategyConfig EMPTY = new BotStrategyConfig(null, null, null);

    private BotStrategyConfig(Integer maxIterations, Integer maxDepth, Long maxTimeMillis) {
        this.maxIterations = maxIterations;
        this.maxDepth = maxDepth;
        this.maxTimeMillis = maxTimeMillis;
    }

    public Integer getMaxIterations() {
        return this.maxIterations;
    }

    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public Long getMaxTimeMillis() {
        return this.maxTimeMillis;
    }

    public boolean hasMaxIterations() {
        return this.maxIterations != null;
    }

    public boolean hasMaxDepth() {
        return this.maxDepth != null;
    }

    public boolean hasMaxTimeMillis() {
        return this.maxTimeMillis != null;
    }

    public boolean exceedsMaxIterations(int iterations) {
        return this.hasMaxIterations() && iterations >= this.maxIterations;
    }

    public boolean exceedsMaxDepth(int depth) {
        return this.hasMaxDepth() && depth >= this.maxDepth;
    }

    public boolean exceedsMaxTimeMillis(long timeMillis) {
        return this.hasMaxTimeMillis() && timeMillis >= this.maxTimeMillis;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static BotStrategyConfig empty() {
        return EMPTY;
    }

    public static class Builder {
        private Integer maxIterations;
        private Integer maxDepth;
        private Long maxTimeMillis;

        public Builder maxIterations(Integer maxIterations) {
            this.maxIterations = maxIterations;
            return this;
        }

        public Builder maxDepth(Integer maxDepth) {
            this.maxDepth = maxDepth;
            return this;
        }

        public Builder maxTimeMillis(Long maxTimeMillis) {
            this.maxTimeMillis = maxTimeMillis;
            return this;
        }

        public Builder maxTimeMillis(TimeUnit timeUnit, long time) {
            this.maxTimeMillis = timeUnit.toMillis(time);
            return this;
        }

        public BotStrategyConfig build() {
            return new BotStrategyConfig(this.maxIterations, this.maxDepth, this.maxTimeMillis);
        }
    }
}

