/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.xxdc.oss.example.GameBoard;
import org.xxdc.oss.example.InvalidMoveException;

public record GameBoardLocalImpl(int dimension, String[] content) implements Serializable,
GameBoard
{
    private static final long serialVersionUID = 1L;

    public GameBoardLocalImpl(int dimension) {
        this(dimension, new String[dimension * dimension]);
    }

    public GameBoardLocalImpl {
        if (content.length != dimension * dimension) {
            throw new IllegalArgumentException("Content must be of length " + dimension * dimension);
        }
    }

    @Override
    public String toString() {
        return this.boardAsString();
    }

    private String boardAsString() {
        Object boardString = "";
        for (int i = 0; i < this.dimension; ++i) {
            for (int j = 0; j < this.dimension; ++j) {
                int index = j + i * this.dimension;
                boardString = (String)boardString + this.contentElseBlank(this.content[index]);
            }
            boardString = (String)boardString + "\n";
        }
        return boardString;
    }

    @Override
    public boolean isValidMove(int location) {
        return location >= 0 && location < this.content.length && this.content[location] == null;
    }

    @Override
    public boolean hasChain(String playerMarker) {
        int i;
        int j;
        int chain;
        int i2;
        for (i2 = 0; i2 < this.dimension; ++i2) {
            chain = 0;
            for (j = 0; j < this.dimension; ++j) {
                if (playerMarker.equals(this.content[i2 * this.dimension + j])) {
                    ++chain;
                }
                if (chain != this.dimension) continue;
                return true;
            }
        }
        for (i2 = 0; i2 < this.dimension; ++i2) {
            chain = 0;
            for (j = 0; j < this.dimension; ++j) {
                if (playerMarker.equals(this.content[j * this.dimension + i2])) {
                    ++chain;
                }
                if (chain != this.dimension) continue;
                return true;
            }
        }
        int chain2 = 0;
        for (i = 0; i < this.dimension; ++i) {
            if (playerMarker.equals(this.content[i + this.dimension * (i + 1) - this.dimension])) {
                ++chain2;
            }
            if (chain2 != this.dimension) continue;
            return true;
        }
        chain2 = 0;
        for (i = 0; i < this.dimension; ++i) {
            if (playerMarker.equals(this.content[this.dimension * (i + 1) - (i + 1)])) {
                ++chain2;
            }
            if (chain2 != this.dimension) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMovesAvailable() {
        return Arrays.stream(this.content).anyMatch(m -> m == null);
    }

    private String contentElseBlank(String unit) {
        return unit == null ? "_" : unit;
    }

    @Override
    public GameBoardLocalImpl withMove(String playerMarker, int location) {
        if (!this.isValidMove(location)) {
            throw new InvalidMoveException("Invalid move: " + playerMarker + "@" + location);
        }
        String[] boardCopy = this.getBoardCopy();
        boardCopy[location] = playerMarker;
        return new GameBoardLocalImpl(this.dimension, boardCopy);
    }

    @Override
    public String asJsonString() {
        StringBuilder json = new StringBuilder();
        json.append("{");
        json.append("\"dimension\":").append(this.dimension()).append(",");
        json.append("\"content\":").append(Arrays.stream(this.content()).map(m -> m == null ? "null" : "\"" + m + "\"").collect(Collectors.joining(",", "[", "]")));
        json.append("}");
        return json.toString();
    }

    public GameBoard clone() {
        return new GameBoardLocalImpl(this.dimension, this.getBoardCopy());
    }

    @Override
    public boolean hasPlayer(String playerMarker, int location) {
        return location >= 0 && location < this.content.length && this.content[location] != null && this.content[location].equals(playerMarker);
    }

    private String[] getBoardCopy() {
        String[] boardCopy = new String[this.dimension * this.dimension];
        System.arraycopy(this.content, 0, boardCopy, 0, boardCopy.length);
        return boardCopy;
    }
}

