/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public record GameContext(String id, long createdAt, Map<String, String> metadata) {

    public static final class Builder {
        private String id;
        private final Map<String, String> metadata = new HashMap<String, String>();

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder put(String key, String value) {
            this.metadata.put(Objects.requireNonNull(key), Objects.requireNonNullElse(value, ""));
            return this;
        }

        public Builder putAll(Map<String, String> entries) {
            if (entries != null) {
                this.metadata.putAll(entries);
            }
            return this;
        }

        public GameContext build() {
            Objects.requireNonNull(this.id);
            return new GameContext(this.id, System.currentTimeMillis(), Map.copyOf(this.metadata));
        }
    }
}

