/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.xxdc.oss.example.Game;

public class GamePersistence {
    private static final System.Logger log = System.getLogger(GamePersistence.class.getName());

    public void saveTo(File gameFile, Game game) throws IOException {
        try (FileOutputStream os = new FileOutputStream(gameFile);
             ObjectOutputStream o = new ObjectOutputStream(os);){
            o.writeObject(game);
        }
        log.log(System.Logger.Level.DEBUG, "Saved to game state to: {0}", gameFile);
    }

    public Game loadFrom(File gameFile) throws IOException, ClassNotFoundException {
        try (FileInputStream is = new FileInputStream(gameFile);){
            Game game;
            try (ObjectInputStream o = new ObjectInputStream(is);){
                o.setObjectInputFilter(new GamePersistenceFilter());
                game = (Game)Game.class.cast(o.readObject());
            }
            return game;
        }
    }

    private static class GamePersistenceFilter
    implements ObjectInputFilter {
        private static final long MAX_REFERENCES = 1000L;

        private GamePersistenceFilter() {
        }

        @Override
        public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
            ObjectInputFilter.Status status;
            ObjectInputFilter.FilterInfo filterInfo2 = filterInfo;
            Objects.requireNonNull(filterInfo2);
            ObjectInputFilter.FilterInfo filterInfo3 = filterInfo2;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ObjectInputFilter.FilterInfo.class, ObjectInputFilter.FilterInfo.class}, (ObjectInputFilter.FilterInfo)filterInfo3, n)) {
                    case 0: {
                        ObjectInputFilter.FilterInfo fi = filterInfo3;
                        if (fi.references() <= 1000L) {
                            n = 1;
                            continue block4;
                        }
                        status = ObjectInputFilter.Status.REJECTED;
                        break block4;
                    }
                    case 1: {
                        ObjectInputFilter.FilterInfo fi = filterInfo3;
                        if (fi.serialClass() == null) {
                            n = 2;
                            continue block4;
                        }
                        status = ObjectInputFilter.Status.ALLOWED;
                        break block4;
                    }
                    default: {
                        status = ObjectInputFilter.Status.UNDECIDED;
                        break block4;
                    }
                }
                break;
            }
            return status;
        }
    }
}

