/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Scanner;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.Player;

public record HumanPlayer() implements Player,
Serializable
{
    private static final System.Logger log = System.getLogger(HumanPlayer.class.getName());
    private static final long serialVersionUID = 1L;

    @Override
    public int nextMove(GameState state) {
        int move;
        Input io = System.console() != null ? new ConsoleInput() : new ScannerInput();
        do {
            log.log(System.Logger.Level.INFO, "Player {0}: choose an available location from [0-{1}]: ", state.currentPlayer(), state.board().dimension() * state.board().dimension() - 1);
            try {
                String msg = io.readLine();
                move = Integer.parseInt(msg);
            }
            catch (NumberFormatException e) {
                log.log(System.Logger.Level.TRACE, "Invalid location: {0}", e.getMessage(), e);
                move = -1;
            }
        } while (!state.board().isValidMove(move));
        return move;
    }

    static final class ConsoleInput
    implements Input {
        ConsoleInput() {
        }

        @Override
        public String readLine() {
            return System.console().readLine();
        }
    }

    static final class ScannerInput
    implements Input {
        ScannerInput() {
        }

        @Override
        public String readLine() {
            try (Scanner scanner = new Scanner(new CloseOnExitInputStream(System.in));){
                String string = scanner.nextLine();
                return string;
            }
        }
    }

    public static sealed interface Input
    permits ConsoleInput, ScannerInput {
        public String readLine();
    }

    static class CloseOnExitInputStream
    extends InputStream {
        private final InputStream in;

        public CloseOnExitInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public void close() {
        }

        @Override
        public int read() throws IOException {
            return this.in.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.in.read(b, off, len);
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.in.read(b);
        }
    }
}

