/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.SequencedMap;
import org.xxdc.oss.example.PlayerNode;
import org.xxdc.oss.example.PlayerPrinter;

public class PlayerNodes
implements Serializable {
    private static final System.Logger log = System.getLogger(PlayerNodes.class.getName());
    private static final long serialVersionUID = 1L;
    private final SequencedMap<String, PlayerNode> players = new LinkedHashMap<String, PlayerNode>(2);
    private final List<String> playerMarkers = new ArrayList<String>(2);

    public static PlayerNodes of(PlayerNode ... players) {
        PlayerNodes playerList = new PlayerNodes();
        for (PlayerNode p : players) {
            playerList.tryAddPlayer(p);
        }
        return playerList;
    }

    public PlayerNode byIndex(int index) {
        return (PlayerNode)this.players.get(this.playerMarkers.get(index));
    }

    public int nextPlayerIndex(int index) {
        return index + 1 < this.players.size() ? index + 1 : 0;
    }

    public void render() {
        PlayerPrinter printer = new PlayerPrinter();
        log.log(System.Logger.Level.INFO, "Players: {0} ({1})", this.playerMarkers(), this.players.values());
        for (PlayerNode player : this.players.values()) {
            log.log(System.Logger.Level.INFO, "- {0}", printer.getPlayerIdentifier(player));
        }
    }

    public String playerMarkers() {
        return String.join((CharSequence)", ", this.players.sequencedKeySet());
    }

    public List<String> playerMarkerList() {
        return new ArrayList<String>(this.playerMarkers);
    }

    private void tryAddPlayer(PlayerNode player) {
        String playerMarker = player.playerMarker();
        if (this.players.containsKey(playerMarker)) {
            throw new RuntimeException("Unable to add player " + String.valueOf(player) + " as player with marker '" + playerMarker + "' already exists.");
        }
        this.players.put(playerMarker, player);
        this.playerMarkers.add(playerMarker);
    }

    public void close() {
        this.players.values().forEach(p -> {
            if (p instanceof AutoCloseable) {
                AutoCloseable c = (AutoCloseable)((Object)p);
                try {
                    c.close();
                }
                catch (Exception e) {
                    log.log(System.Logger.Level.WARNING, "Unable to close player " + String.valueOf(p), (Throwable)e);
                }
            }
        });
    }
}

