/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.bot;

import java.util.Iterator;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.bot.BotStrategy;
import org.xxdc.oss.example.bot.BotStrategyConfig;

public final class AlphaBeta
implements BotStrategy {
    private static final System.Logger log = System.getLogger(AlphaBeta.class.getName());
    private static final int MIN_SCORE = -100;
    private static final int MAX_SCORE = 100;
    private static final int DRAW_SCORE = 0;
    private final String maximizer;
    private final GameState initialState;
    private final BotStrategyConfig config;

    public AlphaBeta(GameState initialState) {
        this(initialState, BotStrategyConfig.newBuilder().build());
    }

    public AlphaBeta(GameState initialState, BotStrategyConfig config) {
        this.initialState = initialState;
        this.maximizer = initialState.currentPlayer();
        if (initialState.playerMarkers().size() != 2) {
            throw new IllegalArgumentException("Minimax AlphaBeta requires exactly two players");
        }
        this.config = config;
    }

    @Override
    public int bestMove() {
        int bestMove = -1;
        int maxScore = -2147483647;
        for (int move : this.initialState.availableMoves()) {
            GameState newState = this.initialState.afterPlayerMoves(move);
            int score = this.alphabeta(newState, false, 0);
            this.log(move, score, 0);
            if (score <= maxScore) continue;
            maxScore = score;
            bestMove = move;
        }
        return bestMove;
    }

    private int alphabeta(GameState state, boolean isMaximizing, int depth) {
        return this.alphabeta(state, isMaximizing, -2147483647, Integer.MAX_VALUE, depth);
    }

    private int alphabeta(GameState state, boolean isMaximizing, int alpha, int beta, int depth) {
        int move;
        GameState newState;
        int score;
        if (state.hasChain(this.maximizer)) {
            return 100 - depth;
        }
        if (state.hasChain(this.opponent(this.maximizer))) {
            return -100 + depth;
        }
        if (!state.hasMovesAvailable() || this.config.exceedsMaxDepth(depth)) {
            return 0;
        }
        if (isMaximizing) {
            int move2;
            GameState newState2;
            int score2;
            int value = -2147483647;
            Iterator<Integer> iterator = state.availableMoves().iterator();
            while (iterator.hasNext() && (value = Math.max(value, score2 = this.alphabeta(newState2 = state.afterPlayerMoves(move2 = iterator.next().intValue()), false, alpha, beta, depth + 1))) <= beta) {
                alpha = Math.max(alpha, value);
            }
            return value;
        }
        int value = Integer.MAX_VALUE;
        Iterator<Integer> iterator = state.availableMoves().iterator();
        while (iterator.hasNext() && (value = Math.min(value, score = this.alphabeta(newState = state.afterPlayerMoves(move = iterator.next().intValue()), true, alpha, beta, depth + 1))) >= alpha) {
            beta = Math.min(beta, value);
        }
        return value;
    }

    private void log(int location, int score, int depth) {
        String indent = "-".repeat(depth);
        log.log(System.Logger.Level.DEBUG, "{0}{1}: Location: {2} Score: {3}", indent, this.maximizer, location, score);
    }

    private String opponent(String playerMarker) {
        return this.initialState.playerMarkers().stream().dropWhile(playerMarker::equals).findFirst().orElseThrow();
    }
}

