/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.bot;

import java.util.concurrent.TimeUnit;
import java.util.function.ToIntFunction;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.bot.AlphaBeta;
import org.xxdc.oss.example.bot.BotStrategyConfig;
import org.xxdc.oss.example.bot.Custom;
import org.xxdc.oss.example.bot.MaxN;
import org.xxdc.oss.example.bot.Minimax;
import org.xxdc.oss.example.bot.MonteCarloTreeSearch;
import org.xxdc.oss.example.bot.Paranoid;
import org.xxdc.oss.example.bot.Random;

public sealed interface BotStrategy
permits AlphaBeta, Minimax, MaxN, Random, Paranoid, MonteCarloTreeSearch, Custom {
    public static final ToIntFunction<GameState> RANDOM = BotStrategy.random(BotStrategyConfig.empty());
    public static final ToIntFunction<GameState> MINIMAX = BotStrategy.minimax(BotStrategyConfig.empty());
    public static final ToIntFunction<GameState> ALPHABETA = BotStrategy.alphabeta(BotStrategyConfig.empty());
    public static final ToIntFunction<GameState> MAXN = BotStrategy.maxn(BotStrategyConfig.empty());
    public static final ToIntFunction<GameState> PARANOID = BotStrategy.paranoid(BotStrategyConfig.empty());
    public static final ToIntFunction<GameState> MCTS = BotStrategy.mcts(BotStrategyConfig.newBuilder().maxTimeMillis(TimeUnit.SECONDS, 2L).build());
    public static final ToIntFunction<GameState> DEFAULT = RANDOM;

    public int bestMove();

    public static ToIntFunction<GameState> random(BotStrategyConfig config) {
        return state -> {
            Random strategy = new Random((GameState)state);
            return strategy.bestMove();
        };
    }

    public static ToIntFunction<GameState> minimax(BotStrategyConfig config) {
        return state -> {
            Minimax strategy = new Minimax((GameState)state, config);
            return strategy.bestMove();
        };
    }

    public static ToIntFunction<GameState> alphabeta(BotStrategyConfig config) {
        return state -> {
            AlphaBeta alphabeta = new AlphaBeta((GameState)state, config);
            return alphabeta.bestMove();
        };
    }

    public static ToIntFunction<GameState> maxn(BotStrategyConfig config) {
        return state -> {
            MaxN maxn = new MaxN((GameState)state, config);
            return maxn.bestMove();
        };
    }

    public static ToIntFunction<GameState> paranoid(BotStrategyConfig config) {
        return state -> {
            Paranoid paranoid = new Paranoid((GameState)state, config);
            return paranoid.bestMove();
        };
    }

    public static ToIntFunction<GameState> mcts(BotStrategyConfig config) {
        return state -> {
            MonteCarloTreeSearch montecarlo = new MonteCarloTreeSearch((GameState)state, config);
            return montecarlo.bestMove();
        };
    }
}

