/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.bot;

import java.util.Arrays;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.bot.BotStrategy;
import org.xxdc.oss.example.bot.BotStrategyConfig;

public final class MaxN
implements BotStrategy {
    private static final System.Logger log = System.getLogger(MaxN.class.getName());
    private static final int MAX_SCORE = 100;
    private static final int MIN_SCORE = -100;
    private final GameState initialState;
    private final BotStrategyConfig config;

    public MaxN(GameState initialState) {
        this(initialState, BotStrategyConfig.empty());
    }

    public MaxN(GameState initialState, BotStrategyConfig config) {
        this.initialState = initialState;
        this.config = config;
    }

    @Override
    public int bestMove() {
        int bestMove = -1;
        int[] maxScores = new int[this.numberOfPlayers()];
        Arrays.fill(maxScores, Integer.MIN_VALUE);
        for (int move : this.initialState.availableMoves()) {
            GameState newState = this.initialState.afterPlayerMoves(move);
            int[] scores = this.maxn(newState, 0);
            this.log(move, scores, 0);
            if (scores[newState.lastPlayerIndex()] <= maxScores[newState.lastPlayerIndex()]) continue;
            maxScores = scores;
            bestMove = move;
        }
        return bestMove;
    }

    private int[] maxn(GameState state, int depth) {
        if (state.lastPlayerHasChain()) {
            int[] scores = new int[this.numberOfPlayers()];
            Arrays.fill(scores, -100 + depth);
            scores[state.lastPlayerIndex()] = 100 - depth;
            return scores;
        }
        if (!state.hasMovesAvailable() || this.config.exceedsMaxDepth(depth)) {
            return new int[this.numberOfPlayers()];
        }
        int[] bestScores = new int[this.numberOfPlayers()];
        Arrays.fill(bestScores, Integer.MIN_VALUE);
        for (int move : state.availableMoves()) {
            GameState newState = state.afterPlayerMoves(move);
            int[] scores = this.maxn(newState, depth + 1);
            if (scores[state.currentPlayerIndex()] <= bestScores[state.currentPlayerIndex()]) continue;
            bestScores = scores;
        }
        return bestScores;
    }

    private String currentPlayer() {
        return this.initialState.currentPlayer();
    }

    private int numberOfPlayers() {
        return this.initialState.playerMarkers().size();
    }

    private void log(int location, int[] scores, int depth) {
        String indent = "-".repeat(depth);
        if (log.isLoggable(System.Logger.Level.DEBUG)) {
            log.log(System.Logger.Level.DEBUG, "{0}{1}: Location: {2} Scores: {3}", indent, this.currentPlayer(), location, Arrays.toString(scores));
        }
    }
}

