/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import org.xxdc.oss.example.BotPlayer;
import org.xxdc.oss.example.Game;
import org.xxdc.oss.example.Player;
import org.xxdc.oss.example.PlayerNode;
import org.xxdc.oss.example.analysis.Analyzers;
import org.xxdc.oss.example.bot.BotStrategy;
import org.xxdc.oss.example.commentary.EsportsLiveCommentaryPersona;
import org.xxdc.oss.example.commentary.EsportsPostAnalysisCommentaryPersona;

public class AppTrainer {
    private static final System.Logger log = System.getLogger(AppTrainer.class.getName());

    public void run() throws Exception {
        try (Game game = this.newStandardGame();){
            game.playWithAction(this::logLiveCommentary);
            this.logPostAnalysisCommentary(game);
        }
    }

    private void logLiveCommentary(Game game) {
        EsportsLiveCommentaryPersona commentary = new EsportsLiveCommentaryPersona();
        game.history().stream().skip(game.moveNumber() - 1).gather(Analyzers.strategicTurningPoints()).map(arg_0 -> ((EsportsLiveCommentaryPersona)commentary).comment(arg_0)).forEach(l -> log.log(System.Logger.Level.INFO, "\"{0}\"", l));
    }

    private void logPostAnalysisCommentary(Game game) {
        log.log(System.Logger.Level.INFO, "Post-Game Analysis:");
        EsportsPostAnalysisCommentaryPersona commentary = new EsportsPostAnalysisCommentaryPersona();
        game.history().stream().gather(Analyzers.strategicTurningPoints()).map(arg_0 -> ((EsportsPostAnalysisCommentaryPersona)commentary).comment(arg_0)).forEach(l -> log.log(System.Logger.Level.INFO, "- \"{0}\"", l));
    }

    public String getGreeting() {
        return "Welcome to Tic-Tac-Toe!";
    }

    public static void main(String[] args) throws Exception {
        AppTrainer app = new AppTrainer();
        log.log(System.Logger.Level.INFO, app::getGreeting);
        app.run();
    }

    private Game newStandardGame() {
        return new Game(3, false, new PlayerNode[]{new PlayerNode.Local("X", (Player)new BotPlayer(BotStrategy.ALPHABETA)), new PlayerNode.Local("O", (Player)new BotPlayer(BotStrategy.ALPHABETA))});
    }
}

