/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.xxdc.oss.example.BotPlayer;
import org.xxdc.oss.example.bot.BotStrategy;
import org.xxdc.oss.example.transport.tcp.TcpTransportClient;
import org.xxdc.oss.example.transport.tcp.TcpTransports;

public class GameClient {
    private static final System.Logger log = System.getLogger(GameClient.class.getName());
    private final int maxGames;
    private final String serverHost;
    private final int serverSocket;
    private final LongAdder submittedClients = new LongAdder();
    private final LongAdder completedClients = new LongAdder();
    private final LongAdder failedClients = new LongAdder();
    private final LongAdder startedClients = new LongAdder();

    public GameClient(int maxGames, String serverHost, int serverPort) {
        this.maxGames = maxGames;
        this.serverHost = serverHost;
        this.serverSocket = serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ExecutorService executor = Executors.newVirtualThreadPerTaskExecutor();
        log.log(System.Logger.Level.INFO, "Client connecting for Tic-Tac-Toe.");
        long elapsed = System.currentTimeMillis();
        GameClient client = new GameClient(1000, args.length > 0 ? args[0] : "localhost", args.length > 1 ? Integer.parseInt(args[1]) : 9090);
        try {
            client.connectToServer(executor);
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.MINUTES);
            elapsed = System.currentTimeMillis() - elapsed;
            log.log(System.Logger.Level.INFO, "Elapsed: " + elapsed);
            log.log(System.Logger.Level.INFO, "Finished.");
        }
        catch (Throwable throwable) {
            log.log(System.Logger.Level.INFO, "Finished.");
            log.log(System.Logger.Level.INFO, "Submitted {0} clients for {1} games.", client.submittedClients.sum(), client.maxGames);
            log.log(System.Logger.Level.INFO, "Started {0} clients for {1} games.", client.startedClients.sum(), client.maxGames);
            log.log(System.Logger.Level.INFO, "Failed {0} clients for {1} games.", client.failedClients.sum(), client.maxGames);
            log.log(System.Logger.Level.INFO, "Completed {0} clients for {1} games.", client.completedClients.sum(), client.maxGames);
            throw throwable;
        }
        log.log(System.Logger.Level.INFO, "Submitted {0} clients for {1} games.", client.submittedClients.sum(), client.maxGames);
        log.log(System.Logger.Level.INFO, "Started {0} clients for {1} games.", client.startedClients.sum(), client.maxGames);
        log.log(System.Logger.Level.INFO, "Failed {0} clients for {1} games.", client.failedClients.sum(), client.maxGames);
        log.log(System.Logger.Level.INFO, "Completed {0} clients for {1} games.", client.completedClients.sum(), client.maxGames);
    }

    private void connectToServer(ExecutorService executor) {
        while (this.submittedClients.sum() < (long)(2 * this.maxGames)) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            executor.submit(() -> {
                try (Socket socket2 = new Socket(this.serverHost, this.serverSocket);
                     TcpTransportClient<BotPlayer> client = TcpTransports.newTcpTransportClient(new BotPlayer(BotStrategy.MINIMAX), socket2);){
                    this.startedClients.increment();
                    socket2.setKeepAlive(true);
                    log.log(System.Logger.Level.INFO, "Started {0} clients.", this.startedClients.sum());
                    client.run();
                    this.completedClients.increment();
                }
                catch (ConnectException socket2) {
                    this.failedClients.increment();
                    log.log(System.Logger.Level.ERROR, "Connect exception, server down.");
                }
                catch (SocketException e) {
                    this.failedClients.increment();
                    log.log(System.Logger.Level.ERROR, "Socket exception, server disconnected: {}", e.getMessage());
                }
                catch (Exception e) {
                    this.failedClients.increment();
                    log.log(System.Logger.Level.ERROR, "Unexpected exception: {}", e.getMessage());
                    throw new RuntimeException(e);
                }
            });
            this.submittedClients.increment();
        }
    }
}

