/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import org.xxdc.oss.example.Game;
import org.xxdc.oss.example.PlayerNode;
import org.xxdc.oss.example.transport.TransportServer;
import org.xxdc.oss.example.transport.tcp.TcpTransportServer;

public class GameServer {
    private static final System.Logger log = System.getLogger(GameServer.class.getName());
    private static final int CONNECTION_TIMEOUT = 30000;
    private final LongAdder concurrentGames = new LongAdder();
    private final LongAccumulator maxConcurrentGames = new LongAccumulator(Long::max, 0L);
    private final LongAccumulator totalGames = new LongAccumulator(Long::sum, 0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        GameServer server = new GameServer();
        try {
            try (ServerSocket serverSocket = new ServerSocket(args.length > 0 ? Integer.parseInt(args[0]) : 9090, 10000);
                 ExecutorService executor = GameServer.newVirtualThreadExecutor();){
                serverSocket.setSoTimeout(30000);
                log.log(System.Logger.Level.INFO, "Starting tic-tac-toe game server at {0}", serverSocket);
                server.listenForPlayers(executor, serverSocket);
            }
            log.log(System.Logger.Level.INFO, "Server shutting down...");
        }
        catch (Exception e) {
            try {
                GameServer.handleException(e);
                log.log(System.Logger.Level.INFO, "Server shutting down...");
            }
            catch (Throwable throwable) {
                log.log(System.Logger.Level.INFO, "Server shutting down...");
                log.log(System.Logger.Level.INFO, "Total games played: {0}", server.totalGames.get());
                log.log(System.Logger.Level.INFO, "Maximum number of concurrent games: {0}", server.maxConcurrentGames.get());
                throw throwable;
            }
            log.log(System.Logger.Level.INFO, "Total games played: {0}", server.totalGames.get());
            log.log(System.Logger.Level.INFO, "Maximum number of concurrent games: {0}", server.maxConcurrentGames.get());
        }
        log.log(System.Logger.Level.INFO, "Total games played: {0}", server.totalGames.get());
        log.log(System.Logger.Level.INFO, "Maximum number of concurrent games: {0}", server.maxConcurrentGames.get());
    }

    private static ExecutorService newVirtualThreadExecutor() {
        ThreadFactory threadFactory = Thread.ofVirtual().name("ttt-virtual-", 1L).factory();
        ExecutorService executor = Executors.newThreadPerTaskExecutor(threadFactory);
        return executor;
    }

    private static void handleException(Exception e) {
        Throwable cause = e;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        Exception exception = cause;
        Objects.requireNonNull(exception);
        Exception exception2 = exception;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SocketTimeoutException.class}, (Throwable)exception2, n)) {
            case 0: {
                SocketTimeoutException se = (SocketTimeoutException)exception2;
                log.log(System.Logger.Level.INFO, "Server connection timed out after {0}ms.", 30000);
                break;
            }
            default: {
                log.log(System.Logger.Level.ERROR, "Unexpected exception: {0}", e.getMessage(), e);
            }
        }
    }

    private void listenForPlayers(ExecutorService executor, ServerSocket serverSocket) throws IOException {
        while (true) {
            log.log(System.Logger.Level.INFO, "Waiting for players to connect...");
            CompletableFuture<Socket> clientSocket1Future = CompletableFuture.supplyAsync(this.clientSocket(serverSocket), executor);
            CompletableFuture<Socket> clientSocket2Future = CompletableFuture.completedFuture(this.clientSocket(serverSocket).get());
            clientSocket1Future.thenCombineAsync(clientSocket2Future, (clientSocket1, clientSocket2) -> {
                try {
                    PlayerNode.Remote playerX = new PlayerNode.Remote("X", (TransportServer)new TcpTransportServer((Socket)clientSocket1));
                    PlayerNode.Remote playerO = new PlayerNode.Remote("O", (TransportServer)new TcpTransportServer((Socket)clientSocket2));
                    log.log(System.Logger.Level.INFO, "{0} concurrent games in progress.", this.updateStatsAndGetConcurrentGames());
                    Game game = new Game(3, false, new PlayerNode[]{playerX, playerO});
                    game.play();
                    game.close();
                    Game game2 = game;
                    return game2;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.concurrentGames.decrement();
                }
            }, (Executor)executor);
        }
    }

    private Supplier<Socket> clientSocket(ServerSocket serverSocket) {
        return () -> {
            try {
                return serverSocket.accept();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private long updateStatsAndGetConcurrentGames() {
        this.concurrentGames.increment();
        this.totalGames.accumulate(1L);
        long currentConcurrentGames = this.concurrentGames.longValue();
        this.maxConcurrentGames.accumulate(currentConcurrentGames);
        return currentConcurrentGames;
    }
}

