/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.security;

import java.lang.runtime.SwitchBootstraps;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;
import javax.crypto.DecapsulateException;
import javax.crypto.KEM;
import javax.crypto.KEMSpi;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.bouncycastle.jcajce.SecretKeyWithEncapsulation;
import org.bouncycastle.jcajce.spec.KEMExtractSpec;
import org.bouncycastle.jcajce.spec.KEMGenerateSpec;
import org.bouncycastle.pqc.jcajce.spec.KyberParameterSpec;
import org.xxdc.oss.example.security.KyberParams;

public class KyberKEMSpi
implements KEMSpi {
    /*
     * Enabled aggressive block sorting
     */
    @Override
    public KEMSpi.EncapsulatorSpi engineNewEncapsulator(PublicKey publicKey, AlgorithmParameterSpec spec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (publicKey == null) {
            throw new InvalidKeyException("input key is null");
        }
        AlgorithmParameterSpec algorithmParameterSpec = spec;
        Objects.requireNonNull(algorithmParameterSpec);
        AlgorithmParameterSpec algorithmParameterSpec2 = algorithmParameterSpec;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KyberParameterSpec.class}, (AlgorithmParameterSpec)algorithmParameterSpec2, n)) {
            case 0: {
                KyberParameterSpec kSpec = (KyberParameterSpec)algorithmParameterSpec2;
                return new KyberEncapsulatorDecapsulatorSpi(publicKey, kSpec, secureRandom);
            }
        }
        throw new InvalidAlgorithmParameterException("Incompatible spec " + String.valueOf(spec.getClass()) + " for Kyber.");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public KEMSpi.DecapsulatorSpi engineNewDecapsulator(PrivateKey privateKey, AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException, InvalidKeyException {
        if (privateKey == null) {
            throw new InvalidKeyException("input key is null");
        }
        AlgorithmParameterSpec algorithmParameterSpec = spec;
        Objects.requireNonNull(algorithmParameterSpec);
        AlgorithmParameterSpec algorithmParameterSpec2 = algorithmParameterSpec;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KyberParameterSpec.class}, (AlgorithmParameterSpec)algorithmParameterSpec2, n)) {
            case 0: {
                KyberParameterSpec kSpec = (KyberParameterSpec)algorithmParameterSpec2;
                return new KyberEncapsulatorDecapsulatorSpi(privateKey, kSpec);
            }
        }
        throw new InvalidAlgorithmParameterException("Incompatible spec " + String.valueOf(spec.getClass()) + " for Kyber.");
    }

    private static class KyberEncapsulatorDecapsulatorSpi
    implements KEMSpi.EncapsulatorSpi,
    KEMSpi.DecapsulatorSpi {
        private PublicKey publicKey;
        private PrivateKey privateKey;
        private KyberParameterSpec parameterSpec;
        private SecureRandom random;

        public KyberEncapsulatorDecapsulatorSpi(PublicKey publicKey, KyberParameterSpec parameterSpec, SecureRandom random) {
            this.publicKey = publicKey;
            this.parameterSpec = parameterSpec;
            this.random = random;
        }

        public KyberEncapsulatorDecapsulatorSpi(PrivateKey privateKey, KyberParameterSpec parameterSpec) {
            this.privateKey = privateKey;
            this.parameterSpec = parameterSpec;
        }

        @Override
        public KEM.Encapsulated engineEncapsulate(int from, int to, String algorithm) {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("Kyber", "BCPQC");
                KEMGenerateSpec kemGenerateSpec = new KEMGenerateSpec(this.publicKey, this.parameterSpec.getName());
                if (this.random == null) {
                    keyGenerator.init((AlgorithmParameterSpec)kemGenerateSpec);
                } else {
                    keyGenerator.init((AlgorithmParameterSpec)kemGenerateSpec, this.random);
                }
                SecretKeyWithEncapsulation key = (SecretKeyWithEncapsulation)keyGenerator.generateKey();
                return new KEM.Encapsulated((SecretKey)key, key.getEncapsulation(), KyberParams.byKyberParameterSpec(this.parameterSpec).encode());
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new UnsupportedOperationException(e);
            }
        }

        @Override
        public SecretKey engineDecapsulate(byte[] encapsulation, int from, int to, String algorithm) throws DecapsulateException {
            try {
                KeyGenerator keyGenerator = KeyGenerator.getInstance("Kyber", "BCPQC");
                KEMExtractSpec kemExtractSpec = new KEMExtractSpec(this.privateKey, encapsulation, this.parameterSpec.getName());
                keyGenerator.init((AlgorithmParameterSpec)kemExtractSpec);
                return keyGenerator.generateKey();
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new DecapsulateException("Failed whilst decapsulating.", e);
            }
        }

        @Override
        public int engineSecretSize() {
            return KyberParams.byKyberParameterSpec(this.parameterSpec).parameters().getSessionKeySize();
        }

        @Override
        public int engineEncapsulationSize() {
            return KyberParams.byKyberParameterSpec(this.parameterSpec).parameters().getSessionKeySize();
        }
    }
}

