/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.transport;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.xxdc.oss.example.transport.MessageHandler;

public class DuplexMessageHandler
implements MessageHandler {
    private final ObjectOutputStream out;
    private final ObjectInputStream in;
    private volatile boolean initialized = false;

    public DuplexMessageHandler(ObjectOutputStream out, ObjectInputStream in) {
        this.out = out;
        this.in = in;
    }

    @Override
    public void sendMessage(String message) throws IOException {
        this.checkInitialized();
        this.sendBytes(message.getBytes());
    }

    @Override
    public String receiveMessage() throws IOException {
        this.checkInitialized();
        return new String(this.receiveBytes());
    }

    @Override
    public void close() throws Exception {
        this.in.close();
        this.out.close();
    }

    @Override
    public void init() {
        this.initialized = true;
    }

    void sendObject(Object object) throws IOException {
        this.checkInitialized();
        this.out.writeObject(object);
        this.out.flush();
    }

    Object receiveObject() throws IOException, ClassNotFoundException {
        this.checkInitialized();
        return this.in.readObject();
    }

    void sendBytes(byte[] bytes) throws IOException {
        this.checkInitialized();
        this.out.writeInt(bytes.length);
        this.out.write(bytes);
        this.out.flush();
    }

    byte[] receiveBytes() throws IOException {
        this.checkInitialized();
        int sz = this.in.readInt();
        byte[] data = new byte[sz];
        this.in.readFully(data);
        return data;
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("MessageHandler has not been initialized.");
        }
    }
}

