/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.transport;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.DecapsulateException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.xxdc.oss.example.transport.DuplexMessageHandler;
import org.xxdc.oss.example.transport.MessageHandler;

public abstract class SecureDuplexMessageHandler
implements MessageHandler {
    private static final System.Logger log = System.getLogger(SecureDuplexMessageHandler.class.getName());
    protected final DuplexMessageHandler handler;
    protected SecretKey sharedKey;
    protected boolean initialized = false;

    public SecureDuplexMessageHandler(DuplexMessageHandler handler) {
        this.handler = handler;
    }

    @Override
    public abstract void init() throws IOException;

    protected abstract SecretKey exchangeSharedKey() throws NoSuchAlgorithmException, IOException, NoSuchProviderException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException, DecapsulateException, ClassNotFoundException;

    @Override
    public void sendMessage(String message) throws IOException {
        this.checkInitialized();
        try {
            Cipher cipher = this.newCipherInstance();
            byte[] iv = new byte[12];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
            SecretKeySpec aesKey = new SecretKeySpec(this.sharedKey.getEncoded(), 0, 32, "AES");
            cipher.init(1, (Key)aesKey, ivSpec);
            byte[] ciphertext = cipher.doFinal(message.getBytes());
            byte[] ivAndCiphertext = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, ivAndCiphertext, 0, iv.length);
            System.arraycopy(ciphertext, 0, ivAndCiphertext, iv.length, ciphertext.length);
            this.handler.sendBytes(ivAndCiphertext);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Invalid security configuration/exchange whilst sending message: " + e.getMessage(), e);
        }
    }

    @Override
    public String receiveMessage() throws IOException {
        this.checkInitialized();
        try {
            byte[] ivAndCiphertext = this.handler.receiveBytes();
            byte[] iv = new byte[12];
            System.arraycopy(ivAndCiphertext, 0, iv, 0, iv.length);
            GCMParameterSpec ivParameterSpec = new GCMParameterSpec(128, iv);
            int ciphertextSize = ivAndCiphertext.length - iv.length;
            byte[] ciphertext = new byte[ciphertextSize];
            System.arraycopy(ivAndCiphertext, iv.length, ciphertext, 0, ciphertextSize);
            Cipher cipher = this.newCipherInstance();
            SecretKeySpec aesKey = new SecretKeySpec(this.sharedKey.getEncoded(), 0, 32, "AES");
            cipher.init(2, (Key)aesKey, ivParameterSpec);
            byte[] decryptedText = cipher.doFinal(ciphertext);
            return new String(decryptedText);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new IllegalArgumentException("Invalid security configuration/exchange whilst receiving message: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws Exception {
        this.handler.close();
    }

    private Cipher newCipherInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        return Cipher.getInstance("AES/GCM/NoPadding");
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("SecureMessageHandler has not been initialized.");
        }
    }
}

