/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.transport;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import javax.crypto.KEM;
import javax.crypto.SecretKey;
import org.xxdc.oss.example.transport.DuplexMessageHandler;
import org.xxdc.oss.example.transport.SecureDuplexMessageHandler;

public final class SecureKyberClient
extends SecureDuplexMessageHandler {
    private static final System.Logger log = System.getLogger(MethodHandles.lookup().lookupClass().getName());

    public SecureKyberClient(DuplexMessageHandler handler) {
        super(handler);
    }

    @Override
    public void init() throws IOException {
        try {
            this.handler.init();
            log.log(System.Logger.Level.DEBUG, "Initializing secure channel for {0}. Exchanging shared key...", this.getClass().getSimpleName());
            this.sharedKey = this.exchangeSharedKey();
            this.initialized = true;
            log.log(System.Logger.Level.DEBUG, "Secure connection for {0} established with {1} shared key.", this.getClass().getSimpleName(), this.sharedKey.getAlgorithm());
        }
        catch (IOException | ClassNotFoundException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalArgumentException("Invalid security configuration/exchange: " + e.getMessage(), e);
        }
    }

    @Override
    protected SecretKey exchangeSharedKey() throws NoSuchAlgorithmException, NoSuchProviderException, ClassNotFoundException, IOException, InvalidAlgorithmParameterException, InvalidKeyException {
        KEM kem = KEM.getInstance("ML-KEM-1024");
        PublicKey publicKey = this.retrieveKey();
        KEM.Encapsulator encapsulator = kem.newEncapsulator(publicKey);
        KEM.Encapsulated encapsulated = encapsulator.encapsulate();
        this.handler.sendBytes(encapsulated.encapsulation());
        return encapsulated.key();
    }

    private PublicKey retrieveKey() throws ClassNotFoundException, IOException {
        return (PublicKey)this.handler.receiveObject();
    }
}

