/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.transport.tcp;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.Player;
import org.xxdc.oss.example.transport.MessageHandler;
import org.xxdc.oss.example.transport.TransportException;
import org.xxdc.oss.example.transport.tcp.TcpProtocol;

public record TcpTransportClient<T extends Player>(MessageHandler connection, T player) implements AutoCloseable
{
    private static final System.Logger log = System.getLogger(MethodHandles.lookup().lookupClass().getName());

    public TcpTransportClient(MessageHandler connection, T player) {
        try {
            this.connection = connection;
            this.player = player;
            this.connection.init();
        }
        catch (IOException e) {
            throw new TransportException((Throwable)e);
        }
    }

    public void run() {
        log.log(System.Logger.Level.DEBUG, "Started TCP transport client");
        try {
            String msg;
            String playerMarker = this.initPlayerMarker();
            log.log(System.Logger.Level.DEBUG, "Playing as {0}", playerMarker);
            while ((msg = this.connection.receiveMessage()) != null && !msg.equals("{}")) {
                log.log(System.Logger.Level.DEBUG, "Received message from server: {0} for {1}", msg, this.player);
                TcpProtocol.fromNextMoveState(msg).ifPresentOrElse(state -> this.makeMove((GameState)state), () -> {
                    log.log(System.Logger.Level.ERROR, "Invalid message from transport");
                    throw new TransportException("Invalid message from transport");
                });
            }
            this.handleExit(msg);
        }
        catch (IOException e) {
            throw new TransportException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private void makeMove(GameState state) {
        int nextMove = this.player.nextMove(state);
        try {
            this.connection.sendMessage(String.valueOf(nextMove));
        }
        catch (IOException e) {
            throw new TransportException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    private void handleExit(String serverMessage) {
        if (serverMessage == null) {
            log.log(System.Logger.Level.DEBUG, "Received null message from server");
        } else {
            log.log(System.Logger.Level.DEBUG, "Received exit code from server");
        }
    }

    private String initPlayerMarker() throws IOException {
        String serverMessage = this.connection.receiveMessage();
        log.log(System.Logger.Level.DEBUG, "Received initial message from server: {0}", serverMessage);
        String playerMarker = TcpProtocol.fromGameStartedState(serverMessage).orElseThrow(() -> new TransportException("Invalid server message received. Expected game started state."));
        log.log(System.Logger.Level.DEBUG, "Received assigned player marker: {0}", playerMarker);
        return playerMarker;
    }
}

