/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.transport.tcp;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import org.xxdc.oss.example.GameState;
import org.xxdc.oss.example.transport.DuplexMessageHandler;
import org.xxdc.oss.example.transport.MessageHandler;
import org.xxdc.oss.example.transport.SecureKyberServer;
import org.xxdc.oss.example.transport.TransportConfiguration;
import org.xxdc.oss.example.transport.TransportException;
import org.xxdc.oss.example.transport.TransportServer;

public class TcpTransportServer
implements TransportServer {
    private static final System.Logger log = System.getLogger(TcpTransportServer.class.getName());
    private final Socket socket;
    private final MessageHandler handler;

    public TcpTransportServer(Socket socket) {
        this.socket = socket;
        try {
            this.handler = new SecureKyberServer(new DuplexMessageHandler(new ObjectOutputStream(socket.getOutputStream()), new ObjectInputStream(socket.getInputStream())));
        }
        catch (IOException e) {
            throw new TransportException("IO exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public TcpTransportServer(Socket socket, MessageHandler handler) {
        this.socket = socket;
        this.handler = handler;
    }

    public void initialize(TransportConfiguration configuration) {
        log.log(System.Logger.Level.DEBUG, "Initializing socket {0} for {1} to client for Tic-Tac-Toe.", this.socket, configuration.playerMarker());
        try {
            this.handler.init();
            this.handler.sendMessage(String.format("{\"version\":1,\"message\":\"start\",\"assignedPlayerMarker\":\"%s\"}", configuration.playerMarker()));
        }
        catch (IOException e) {
            log.log(System.Logger.Level.WARNING, "Error initializing socket {0} for {1} to client for Tic-Tac-Toe.", this.socket, configuration.playerMarker());
            throw new TransportException(e.getMessage(), (Throwable)e);
        }
    }

    public void close() throws Exception {
        if (this.socket.isClosed()) {
            return;
        }
        this.handler.sendMessage("{}");
        this.handler.close();
    }

    public void send(GameState state) {
        try {
            String nextMoveMsg = String.format("{\"version\":1,\"message\":\"nextMove\",\"state\":%s}", state.asJsonString());
            log.log(System.Logger.Level.DEBUG, "Sending message to client: {0}", nextMoveMsg);
            this.handler.sendMessage(nextMoveMsg);
        }
        catch (IOException e) {
            throw new TransportException(e.getMessage(), (Throwable)e);
        }
    }

    public int accept() {
        try {
            String clientMessage = this.handler.receiveMessage();
            return Integer.parseInt(clientMessage);
        }
        catch (IOException e) {
            throw new TransportException(e.getMessage(), (Throwable)e);
        }
    }
}

