/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.transport;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KEM;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.KyberParameterSpec;
import org.xxdc.oss.example.security.KyberKEMProvider;
import org.xxdc.oss.example.transport.DuplexMessageHandler;
import org.xxdc.oss.example.transport.SecureDuplexMessageHandler;

public final class SecureBouncyCastleKyberClient
extends SecureDuplexMessageHandler {
    private static final System.Logger log = System.getLogger(MethodHandles.lookup().lookupClass().getName());

    private void registerSecurityProviders() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.addProvider((Provider)new BouncyCastlePQCProvider());
        Security.addProvider(new KyberKEMProvider());
    }

    public SecureBouncyCastleKyberClient(DuplexMessageHandler handler) {
        super(handler);
        this.registerSecurityProviders();
    }

    @Override
    public void init() throws IOException {
        try {
            this.handler.init();
            log.log(System.Logger.Level.DEBUG, "Initializing secure channel for {0}. Exchanging shared key...", this.getClass().getSimpleName());
            this.sharedKey = this.exchangeSharedKey();
            this.initialized = true;
            log.log(System.Logger.Level.DEBUG, "Secure connection for {0} established with {1} shared key.", this.getClass().getSimpleName(), this.sharedKey.getAlgorithm());
        }
        catch (IOException | ClassNotFoundException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new IllegalArgumentException("Invalid security configuration/exchange: " + e.getMessage(), e);
        }
    }

    @Override
    protected SecretKey exchangeSharedKey() throws NoSuchAlgorithmException, NoSuchProviderException, ClassNotFoundException, IOException, InvalidAlgorithmParameterException, InvalidKeyException {
        KEM kem = KEM.getInstance("Kyber", "BCPQC.KEM");
        PublicKey publicKey = this.retrieveKey();
        KyberParameterSpec paramSpec = KyberParameterSpec.kyber1024;
        KEM.Encapsulator encapsulator = kem.newEncapsulator(publicKey, (AlgorithmParameterSpec)paramSpec, null);
        KEM.Encapsulated encapsulated = encapsulator.encapsulate();
        this.handler.sendBytes(encapsulated.encapsulation());
        this.handler.sendBytes(encapsulated.params());
        return encapsulated.key();
    }

    private PublicKey retrieveKey() throws ClassNotFoundException, IOException {
        return (PublicKey)this.handler.receiveObject();
    }
}

