/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.transport.tcp;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xxdc.oss.example.GameBoard;
import org.xxdc.oss.example.GameState;

public class TcpProtocol {
    public static final String EXIT_CODE = "{}";
    public static final String GAME_STARTED_JSON_FORMAT = "{\"version\":1,\"message\":\"start\",\"assignedPlayerMarker\":\"%s\"}";
    public static final Pattern GAME_STARTED_JSON_PATTERN = Pattern.compile("\\{\\\"version\\\":(\\d+),\\\"message\\\":\\\"([^\\\"]+)\\\",\\\"assignedPlayerMarker\\\":\\\"([^\\\"]+)\\\".*}");
    public static final String NEXT_MOVE_JSON_FORMAT = "{\"version\":1,\"message\":\"nextMove\",\"state\":%s}";
    public static final Pattern NEXT_MOVE_JSON_PATTERN = Pattern.compile("\\{\\\"version\\\":(\\d+),\\\"message\\\":\\\"([^\\\"]+)\\\",\\\"state\\\":\\{\\\"gameId\\\":\\\"([^\\\"]+)\\\",\\\"playerMarkers\\\":\\[(.*)\\],\\\"currentPlayerIndex\\\":(\\d+),\\\"board\\\":\\{\\\"dimension\\\":(\\d+),\\\"content\\\":\\[(.*)\\]\\}.*\\}}");

    private TcpProtocol() {
    }

    public static Optional<GameState> fromNextMoveState(String serverMessage) {
        Matcher matcher = NEXT_MOVE_JSON_PATTERN.matcher(serverMessage);
        GameState state = null;
        if (matcher.matches()) {
            String gameId = matcher.group(3);
            String[] playerMarkers = matcher.group(4).replace("\"", "").split(",");
            int currentPlayerIndex = Integer.parseInt(matcher.group(5));
            int dimension = Integer.parseInt(matcher.group(6));
            GameBoard board = GameBoard.withDimension((int)dimension);
            String[] rawContent = matcher.group(7).split(",");
            for (int i = 0; i < rawContent.length; ++i) {
                if (rawContent[i] == null || rawContent[i].equals("null")) continue;
                board = board.withMove(rawContent[i].replace("\"", ""), i);
            }
            state = new GameState(UUID.fromString(gameId), board, List.of(playerMarkers), currentPlayerIndex);
        }
        return Optional.ofNullable(state);
    }

    public static Optional<String> fromGameStartedState(String serverMessage) {
        Matcher matcher = GAME_STARTED_JSON_PATTERN.matcher(serverMessage);
        String playerMarker = null;
        if (matcher.matches()) {
            playerMarker = matcher.group(3);
        }
        return Optional.ofNullable(playerMarker);
    }
}

