/*
 * Decompiled with CFR 0.152.
 */
package org.xxdc.oss.example.transport;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.DecapsulateException;
import javax.crypto.KEM;
import javax.crypto.SecretKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.jcajce.provider.BouncyCastlePQCProvider;
import org.bouncycastle.pqc.jcajce.spec.KyberParameterSpec;
import org.xxdc.oss.example.security.KyberKEMProvider;
import org.xxdc.oss.example.transport.DuplexMessageHandler;
import org.xxdc.oss.example.transport.SecureDuplexMessageHandler;

public final class SecureBouncyCastleKyberServer
extends SecureDuplexMessageHandler {
    private static final System.Logger log = System.getLogger(MethodHandles.lookup().lookupClass().getName());

    private void registerSecurityProviders() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Security.addProvider((Provider)new BouncyCastlePQCProvider());
        Security.addProvider(new KyberKEMProvider());
    }

    public SecureBouncyCastleKyberServer(DuplexMessageHandler remoteMessageHandler) {
        super(remoteMessageHandler);
        this.registerSecurityProviders();
    }

    @Override
    public void init() throws IOException {
        try {
            this.handler.init();
            log.log(System.Logger.Level.DEBUG, "Initializing secure channel for {0}. Exchanging shared key...", this.getClass().getSimpleName());
            this.sharedKey = this.exchangeSharedKey();
            this.initialized = true;
            log.log(System.Logger.Level.DEBUG, "Secure connection for {0} established with {1} shared key.", this.getClass().getSimpleName(), this.sharedKey.getAlgorithm());
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidParameterSpecException | DecapsulateException e) {
            throw new IllegalArgumentException("Invalid security configuration/exchange: " + e.getMessage(), e);
        }
    }

    @Override
    protected SecretKey exchangeSharedKey() throws NoSuchAlgorithmException, IOException, NoSuchProviderException, InvalidParameterSpecException, InvalidAlgorithmParameterException, InvalidKeyException, DecapsulateException {
        KeyPair keyPair = this.generateKeyPair();
        this.publishKey(keyPair.getPublic());
        byte[] encapsulated = this.handler.receiveBytes();
        byte[] encapsulatedParams = this.handler.receiveBytes();
        KEM kem = KEM.getInstance("Kyber", "BCPQC.KEM");
        AlgorithmParameters params = AlgorithmParameters.getInstance("Kyber");
        params.init(encapsulatedParams);
        KyberParameterSpec paramSpec = params.getParameterSpec(KyberParameterSpec.class);
        KEM.Decapsulator decapsulator = kem.newDecapsulator(keyPair.getPrivate(), (AlgorithmParameterSpec)paramSpec);
        return decapsulator.decapsulate(encapsulated);
    }

    private KeyPair generateKeyPair() throws NoSuchAlgorithmException, IOException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("Kyber");
        return keyPairGen.generateKeyPair();
    }

    public void publishKey(PublicKey pk) throws IOException {
        this.handler.sendObject(pk);
    }
}

