/*
 * Decompiled with CFR 0.152.
 */
package org.xyro.kumulus.graph;

import com.fasterxml.jackson.databind.node.ObjectNode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.storm.generated.Grouping;
import org.jetbrains.annotations.NotNull;
import org.xyro.kumulus.graph.ComponentGraph;
import org.xyro.kumulus.graph.GraphNode;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0014R\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lorg/xyro/kumulus/graph/GraphEdge;", "T", "Lorg/xyro/kumulus/graph/GraphNode;", "", "stream", "", "src", "dest", "grouping", "Lorg/apache/storm/generated/Grouping;", "(Ljava/lang/String;Lorg/xyro/kumulus/graph/GraphNode;Lorg/xyro/kumulus/graph/GraphNode;Lorg/apache/storm/generated/Grouping;)V", "getDest", "()Lorg/xyro/kumulus/graph/GraphNode;", "Lorg/xyro/kumulus/graph/GraphNode;", "getGrouping", "()Lorg/apache/storm/generated/Grouping;", "getSrc", "getStream", "()Ljava/lang/String;", "getGroupingName", "toJson", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "edgeJson", "kumulus"})
public class GraphEdge<T extends GraphNode> {
    @NotNull
    private final String stream;
    @NotNull
    private final T src;
    @NotNull
    private final T dest;
    @NotNull
    private final Grouping grouping;

    @NotNull
    public ObjectNode toJson() {
        ObjectNode objectNode = ComponentGraph.Companion.getMapper().createObjectNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectNode, (String)"ComponentGraph.mapper.createObjectNode()");
        return this.toJson(objectNode);
    }

    @NotNull
    protected ObjectNode toJson(@NotNull ObjectNode edgeJson) {
        Intrinsics.checkParameterIsNotNull((Object)edgeJson, (String)"edgeJson");
        edgeJson.put("stream", this.stream);
        edgeJson.put("grouping", this.getGroupingName(this.grouping));
        edgeJson.put("src", ((GraphNode)this.src).getComponent().getComponentId());
        edgeJson.put("dest", ((GraphNode)this.dest).getComponent().getComponentId());
        return edgeJson;
    }

    @NotNull
    protected String getGroupingName(@NotNull Grouping grouping) {
        Intrinsics.checkParameterIsNotNull((Object)grouping, (String)"grouping");
        return grouping.is_set_all() ? "all" : (grouping.is_set_none() || grouping.is_set_shuffle() || grouping.is_set_local_or_shuffle() ? "shuffle" : (grouping.is_set_fields() ? "fields" : (grouping.is_set_custom_serialized() ? "custom" : "other")));
    }

    @NotNull
    public final String getStream() {
        return this.stream;
    }

    @NotNull
    public final T getSrc() {
        return this.src;
    }

    @NotNull
    public final T getDest() {
        return this.dest;
    }

    @NotNull
    public final Grouping getGrouping() {
        return this.grouping;
    }

    public GraphEdge(@NotNull String stream, @NotNull T src, @NotNull T dest, @NotNull Grouping grouping) {
        Intrinsics.checkParameterIsNotNull((Object)stream, (String)"stream");
        Intrinsics.checkParameterIsNotNull(src, (String)"src");
        Intrinsics.checkParameterIsNotNull(dest, (String)"dest");
        Intrinsics.checkParameterIsNotNull((Object)grouping, (String)"grouping");
        this.stream = stream;
        this.src = src;
        this.dest = dest;
        this.grouping = grouping;
    }
}

