/*
 * Decompiled with CFR 0.152.
 */
package org.xyro.shaded.org.apache.logging.log4j.core.appender.rolling.action;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.xyro.shaded.org.apache.logging.log4j.core.appender.rolling.action.AbstractAction;

public final class CommonsCompressAction
extends AbstractAction {
    private static final int BUF_SIZE = 8102;
    private final String name;
    private final File source;
    private final File destination;
    private final boolean deleteSource;

    public CommonsCompressAction(String name, File source, File destination, boolean deleteSource) {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(destination, "destination");
        this.name = name;
        this.source = source;
        this.destination = destination;
        this.deleteSource = deleteSource;
    }

    @Override
    public boolean execute() throws IOException {
        return CommonsCompressAction.execute(this.name, this.source, this.destination, this.deleteSource);
    }

    public static boolean execute(String name, File source, File destination, boolean deleteSource) throws IOException {
        if (!source.exists()) {
            return false;
        }
        LOGGER.debug("Starting {} compression of {}", (Object)name, (Object)source.getPath());
        try (FileInputStream input = new FileInputStream(source);
             BufferedOutputStream output = new BufferedOutputStream((OutputStream)new CompressorStreamFactory().createCompressorOutputStream(name, (OutputStream)new FileOutputStream(destination)));){
            IOUtils.copy((InputStream)input, (OutputStream)output, (int)8102);
        }
        catch (CompressorException e) {
            throw new IOException(e);
        }
        finally {
            LOGGER.debug("Finished {} compression of {}", (Object)name, (Object)source.getPath());
        }
        if (deleteSource && !source.delete()) {
            LOGGER.warn("Unable to delete " + source.toString() + '.');
        } else {
            LOGGER.debug("Deleted {}", (Object)source.toString());
        }
        return true;
    }

    @Override
    protected void reportException(Exception ex) {
        LOGGER.warn("Exception during " + this.name + " compression of '" + this.source.toString() + "'.", (Throwable)ex);
    }

    public String toString() {
        return CommonsCompressAction.class.getSimpleName() + '[' + this.source + " to " + this.destination + ", deleteSource=" + this.deleteSource + ']';
    }

    public String getName() {
        return this.name;
    }

    public File getSource() {
        return this.source;
    }

    public File getDestination() {
        return this.destination;
    }

    public boolean isDeleteSource() {
        return this.deleteSource;
    }
}

