/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.listeners;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.Serializable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.util.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import yakworks.security.gorm.AppUserService;
import yakworks.security.gorm.model.AppUser;
import yakworks.security.spring.user.SpringUserInfo;

public class SecLoginHandler
implements ApplicationListener<AbstractAuthenticationEvent>,
GroovyObject {
    @Autowired
    private AppUserService userService;
    @Value(value="${yakworks.security.password.expireEnabled:false}")
    private boolean passwordExpiryEnabled;
    @Value(value="${yakworks.security.password.warnDays:30}")
    private int passwordWarnDays;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public SecLoginHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void onApplicationEvent(AbstractAuthenticationEvent event) {
        Object principal = event.getAuthentication().getPrincipal();
        if (event instanceof AuthenticationSuccessEvent && principal instanceof SpringUserInfo) {
            Serializable uid = ((SpringUserInfo)ScriptBytecodeAdapter.castToType((Object)principal, SpringUserInfo.class)).getId();
            if (this.shouldWarnAboutPasswordExpiry(uid)) {
                GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
                if (DefaultTypeTransformation.booleanUnbox((Object)webRequest)) {
                    boolean bl = true;
                    ScriptBytecodeAdapter.invokeMethodN(SecLoginHandler.class, (Object)webRequest.getCurrentRequest().getSession(), (String)"putAt", (Object[])new Object[]{"warnAboutPasswordExpiry", bl});
                }
            }
        }
        if (event instanceof InteractiveAuthenticationSuccessEvent) {
            this.trackLogin((InteractiveAuthenticationSuccessEvent)ScriptBytecodeAdapter.castToType((Object)event, InteractiveAuthenticationSuccessEvent.class));
        }
    }

    public void trackLogin(InteractiveAuthenticationSuccessEvent event) {
        this.userService.trackUserLogin();
    }

    public boolean shouldWarnAboutPasswordExpiry(Serializable userId) {
        if (this.passwordExpiryEnabled) {
            int remainingDays = this.userService.remainingDaysForPasswordExpiry(AppUser.get(userId));
            if (this.passwordWarnDays >= remainingDays) {
                return true;
            }
        }
        return false;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SecLoginHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public AppUserService getUserService() {
        return this.userService;
    }

    @Generated
    public void setUserService(AppUserService appUserService) {
        this.userService = appUserService;
    }

    @Generated
    public boolean getPasswordExpiryEnabled() {
        return this.passwordExpiryEnabled;
    }

    @Generated
    public boolean isPasswordExpiryEnabled() {
        return this.passwordExpiryEnabled;
    }

    @Generated
    public void setPasswordExpiryEnabled(boolean bl) {
        this.passwordExpiryEnabled = bl;
    }

    @Generated
    public int getPasswordWarnDays() {
        return this.passwordWarnDays;
    }

    @Generated
    public void setPasswordWarnDays(int n) {
        this.passwordWarnDays = n;
    }
}

