/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.repository.errors.api;

import gorm.tools.repository.RepoMessage;
import gorm.tools.repository.errors.EmptyErrors;
import gorm.tools.repository.errors.EntityNotFoundException;
import gorm.tools.repository.errors.EntityValidationException;
import gorm.tools.repository.errors.api.ApiError;
import gorm.tools.repository.errors.api.ApiFieldError;
import gorm.tools.support.MsgService;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.grails.datastore.mapping.validation.ValidationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.dao.DataAccessException;
import org.springframework.http.HttpStatus;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public class ApiErrorHandler
implements GroovyObject {
    @Autowired
    private MsgService msgService;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ApiErrorHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public ApiError handleException(Throwable e) {
        return this.handleException("Entity", e);
    }

    public ApiError handleException(Class entityClass, Throwable e) {
        return this.handleException(entityClass.getSimpleName(), e);
    }

    public ApiError handleException(String entityName, Throwable e) {
        HttpStatus status = HttpStatus.UNPROCESSABLE_ENTITY;
        if (e instanceof EntityNotFoundException) {
            return new ApiError(HttpStatus.NOT_FOUND, this.getMsg((MessageSourceResolvable)ScriptBytecodeAdapter.castToType((Object)e, MessageSourceResolvable.class)));
        }
        if (e instanceof EntityValidationException) {
            String detail = null;
            if (((ValidationException)ScriptBytecodeAdapter.castToType((Object)e, ValidationException.class)).getErrors() instanceof EmptyErrors) {
                String string;
                Throwable throwable = e.getCause();
                detail = string = throwable != null ? throwable.getMessage() : null;
            }
            return new ApiError(status, this.getMsg((MessageSourceResolvable)ScriptBytecodeAdapter.castToType((Object)e, MessageSourceResolvable.class)), detail).errors(this.toFieldErrorList(((ValidationException)ScriptBytecodeAdapter.castToType((Object)e, ValidationException.class)).getErrors()));
        }
        if (e instanceof grails.validation.ValidationException) {
            String msg = this.getMsg(RepoMessage.validationError(entityName));
            return new ApiError(status, msg).errors(this.toFieldErrorList(((grails.validation.ValidationException)ScriptBytecodeAdapter.castToType((Object)e, grails.validation.ValidationException.class)).getErrors()));
        }
        if (e instanceof MessageSourceResolvable) {
            return new ApiError(status, this.getMsg((MessageSourceResolvable)ScriptBytecodeAdapter.castToType((Object)e, MessageSourceResolvable.class)));
        }
        if (e instanceof DataAccessException) {
            return new ApiError(status, "Data Access Exception").detail(e.getMessage());
        }
        return new ApiError(HttpStatus.INTERNAL_SERVER_ERROR, "Internal Server Error", e.getMessage());
    }

    public String getMsg(MessageSourceResolvable msr) {
        return this.msgService.getMessage(msr);
    }

    public List<ApiFieldError> toFieldErrorList(Errors errs) {
        List errors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        ObjectError err = null;
        Iterator iterator = errs.getAllErrors().iterator();
        while (iterator.hasNext()) {
            err = (ObjectError)ScriptBytecodeAdapter.castToType(iterator.next(), ObjectError.class);
            ApiFieldError fieldError = new ApiFieldError(this.getMsg((MessageSourceResolvable)err));
            if (err instanceof FieldError) {
                String string;
                ((FieldError)ScriptBytecodeAdapter.castToType((Object)err, FieldError.class)).getField();
                fieldError.setField(string);
            }
            DefaultGroovyMethods.leftShift((List)errors, (Object)fieldError);
        }
        return errors;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ApiErrorHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    @Generated
    public MsgService getMsgService() {
        return this.msgService;
    }

    @Generated
    public void setMsgService(MsgService msgService) {
        this.msgService = msgService;
    }
}

