/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.job;

import gorm.tools.job.SyncJobArgs;
import gorm.tools.job.SyncJobEntity;
import gorm.tools.job.SyncJobService;
import gorm.tools.job.SyncJobState;
import gorm.tools.repository.model.IdGeneratorRepo;
import groovy.json.StreamingJsonBuilder;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.transform.ToString;
import groovy.transform.builder.Builder;
import groovy.transform.builder.SimpleStrategy;
import java.io.BufferedWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.NioGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import yakworks.api.ApiResults;
import yakworks.api.Result;
import yakworks.api.ResultUtils;
import yakworks.commons.io.IOUtils;
import yakworks.commons.json.JsonEngine;
import yakworks.commons.json.JsonStreaming;
import yakworks.commons.lang.Validate;
import yakworks.i18n.MsgService;
import yakworks.i18n.icu.ICUMessageSource;
import yakworks.problem.ProblemTrait;

@Builder(builderStrategy=SimpleStrategy.class, prefix="")
@ToString
public class SyncJobContext
implements GroovyObject {
    private AtomicBoolean ok;
    private SyncJobService syncJobService;
    private SyncJobArgs args;
    private ApiResults results;
    private Object payload;
    private int payloadSize;
    private AtomicInteger processedCount;
    private AtomicInteger problemCount;
    private Path dataPath;
    private Long jobId;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    public SyncJobContext() {
        this(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public SyncJobContext(Map args) {
        MetaClass metaClass;
        AtomicInteger atomicInteger;
        AtomicInteger atomicInteger2;
        AtomicBoolean atomicBoolean;
        this.ok = atomicBoolean = new AtomicBoolean(true);
        this.processedCount = atomicInteger2 = new AtomicInteger();
        this.problemCount = atomicInteger = new AtomicInteger();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (args == null) {
            Map map;
            args = map = ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
        if (args.containsKey("ok")) {
            Object v = args.get("ok");
            this.ok = (AtomicBoolean)ScriptBytecodeAdapter.castToType(v, AtomicBoolean.class);
        }
        if (args.containsKey("syncJobService")) {
            Object v = args.get("syncJobService");
            this.syncJobService = (SyncJobService)ScriptBytecodeAdapter.castToType(v, SyncJobService.class);
        }
        if (args.containsKey("args")) {
            Object v = args.get("args");
            this.args = (SyncJobArgs)ScriptBytecodeAdapter.castToType(v, SyncJobArgs.class);
        }
        if (args.containsKey("results")) {
            Object v = args.get("results");
            this.results = (ApiResults)ScriptBytecodeAdapter.castToType(v, ApiResults.class);
        }
        if (args.containsKey("payload")) {
            Object v = args.get("payload");
            this.payload = v;
        }
        if (args.containsKey("payloadSize")) {
            Object v = args.get("payloadSize");
            this.payloadSize = DefaultTypeTransformation.intUnbox(v);
        }
        if (args.containsKey("processedCount")) {
            Object v = args.get("processedCount");
            this.processedCount = (AtomicInteger)ScriptBytecodeAdapter.castToType(v, AtomicInteger.class);
        }
        if (args.containsKey("problemCount")) {
            Object v = args.get("problemCount");
            this.problemCount = (AtomicInteger)ScriptBytecodeAdapter.castToType(v, AtomicInteger.class);
        }
        if (args.containsKey("dataPath")) {
            Object v = args.get("dataPath");
            this.dataPath = (Path)ScriptBytecodeAdapter.castToType(v, Path.class);
        }
        if (args.containsKey("jobId")) {
            Object v = args.get("jobId");
            this.jobId = (Long)ScriptBytecodeAdapter.castToType(v, Long.class);
        }
    }

    public static SyncJobContext create(Map params) {
        SyncJobContext sjc = new SyncJobContext(params);
        return sjc;
    }

    public SyncJobContext createJob() {
        ApiResults apiResults;
        Long l;
        Validate.notNull((Object)this.payload);
        this.jobId = l = ((IdGeneratorRepo)ScriptBytecodeAdapter.castToType(this.syncJobService.getRepo(), IdGeneratorRepo.class)).generateId();
        this.setPayloadSize(this.payload);
        Map data = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.jobId, "source", this.args.getSource(), "sourceId", this.args.getSourceId(), "state", SyncJobState.Running, "payload", this.payload});
        if (this.payload instanceof Collection && ((Collection)this.payload).size() > 1000) {
            boolean bl = true;
            this.args.setSavePayloadAsFile(bl);
            boolean bl2 = true;
            this.args.setSaveDataAsFile(bl2);
        }
        Boolean bl = this.args.getSavePayload();
        if (bl == null ? false : bl) {
            if (DefaultTypeTransformation.booleanUnbox((Object)this.payload) && DefaultTypeTransformation.booleanUnbox((Object)this.args.getSavePayloadAsFile())) {
                Long l2 = this.writePayloadFile((Collection)ScriptBytecodeAdapter.asType((Object)this.payload, Collection.class));
                ScriptBytecodeAdapter.setProperty((Object)l2, null, (Object)data, (String)"payloadId");
            } else {
                String res = JsonEngine.toJson((Object)this.payload);
                byte[] byArray = res.getBytes();
                ScriptBytecodeAdapter.setProperty((Object)byArray, null, (Object)data, (String)"payloadBytes");
            }
        }
        SyncJobEntity jobEntity = (SyncJobEntity)ScriptBytecodeAdapter.asType(this.syncJobService.getRepo().create(data, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"flush", true, "bindId", true})), SyncJobEntity.class);
        this.results = apiResults = ApiResults.create();
        return this;
    }

    public void setPayloadSize(Object payload) {
        if (payload instanceof Collection) {
            int n;
            this.payloadSize = n = ((Collection)payload).size();
        }
    }

    public void updateJobResults(ApiResults currentResults, Long startTimeMillis) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)currentResults.getOk())) {
            this.ok.set(false);
        }
        boolean curOk = this.ok.get();
        int processedSize = this.processedCount.addAndGet(currentResults.size());
        DecimalFormat decFmt = new DecimalFormat("0.0");
        BigDecimal endTime = (BigDecimal)ScriptBytecodeAdapter.castToType((Object)NumberNumberDiv.div((Number)NumberNumberMinus.minus((Number)System.currentTimeMillis(), (Number)startTimeMillis), (Number)1000), BigDecimal.class);
        String timing = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{decFmt.format(endTime)}, new String[]{"", "s"}));
        String mem = decFmt.format(SyncJobContext.getUsedMem());
        String message = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{currentResults.getOk(), processedSize, this.payloadSize, timing, mem}, new String[]{"slice ok: ", ", processed ", " of ", " in ", ", used mem: ", "gb"}));
        if (!DefaultTypeTransformation.booleanUnbox((Object)currentResults.getOk())) {
            int problemSize = this.problemCount.addAndGet(currentResults.getProblems().size());
            GStringImpl gStringImpl = new GStringImpl(new Object[]{message, problemSize}, new String[]{"", "\n Has ", " problems so far"});
            message = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        if (log.isDebugEnabled()) {
            DefaultGroovyMethods.println((Object)this, (Object)message);
        }
        this.updateJob(currentResults, ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.jobId, "ok", curOk, "message", message}));
    }

    public void appendDataResults(ApiResults currentResults) {
        Boolean bl = this.args.getSaveDataAsFile();
        if (bl == null ? false : bl) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)this.dataPath)) {
                this.initJsonDataFile();
            }
            Reference writer = new Reference((Object)NioGroovyMethods.newWriter((Path)this.dataPath, (boolean)true));
            Reference sjb = new Reference((Object)new StreamingJsonBuilder((Writer)((BufferedWriter)writer.get()), JsonEngine.getGenerator()));
            List<Map> dataList = this.transformResults(currentResults);
            public final class _appendDataResults_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference sjb;
                private /* synthetic */ Reference writer;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _appendDataResults_closure1(Object _outerInstance, Object _thisObject, Reference sjb, Reference writer) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    this.sjb = reference2 = sjb;
                    this.writer = reference = writer;
                }

                public Object doCall(Object it) {
                    ((StreamingJsonBuilder)this.sjb.get()).call((Map)ScriptBytecodeAdapter.castToType((Object)it, Map.class));
                    ((BufferedWriter)this.writer.get()).write(",\n");
                    return null;
                }

                @Generated
                public Object getSjb() {
                    return this.sjb.get();
                }

                @Generated
                public Object getWriter() {
                    return this.writer.get();
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                @Generated
                public Object doCall() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _appendDataResults_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            DefaultGroovyMethods.each(dataList, (Closure)new _appendDataResults_closure1(this, this, sjb, writer));
            IOUtils.flushAndClose((Writer)((BufferedWriter)writer.get()));
        } else {
            this.results.merge((Result)currentResults);
        }
    }

    public SyncJobEntity finishJob(List<Map> renderResults) {
        Map data = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"id", this.jobId, "state", SyncJobState.Finished});
        Boolean bl = this.args.getSaveDataAsFile();
        if (bl == null ? false : bl) {
            public final class _finishJob_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _finishJob_closure2(Object _outerInstance, Object _thisObject) {
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object wr) {
                    ((Writer)wr).write("]\n");
                    return null;
                }

                public Object call(Object args) {
                    return this.doCall(args);
                }

                public Object call() {
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _finishJob_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            NioGroovyMethods.withWriterAppend((Path)this.dataPath, (Closure)new _finishJob_closure2(this, this));
            Long l = this.syncJobService.createAttachment(this.dataPath, ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.jobId}, new String[]{"SyncJobData_", "_.json"})));
            ScriptBytecodeAdapter.invokeMethodN(SyncJobContext.class, (Object)data, (String)"putAt", (Object[])new Object[]{"dataId", l});
        } else {
            List<Map> list;
            List<Map> list2 = renderResults;
            renderResults = list = DefaultTypeTransformation.booleanUnbox(list2) ? list2 : this.transformResults(this.results);
            byte[] byArray = JsonEngine.toJson(renderResults).getBytes();
            ScriptBytecodeAdapter.setProperty((Object)byArray, null, (Object)data, (String)"dataBytes");
            boolean bl2 = this.ok.get();
            ScriptBytecodeAdapter.setProperty((Object)bl2, null, (Object)data, (String)"ok");
        }
        return this.syncJobService.updateJob(data);
    }

    public void updateJob(ApiResults currentResults, Map data) {
        String string = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.jobId}, new String[]{"SyncJob", ""})).intern();
        synchronized (string) {
            this.syncJobService.updateJob(data);
            this.appendDataResults(currentResults);
        }
    }

    public void initJsonDataFile() {
        Path path;
        String filename = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.jobId}, new String[]{"SyncJobData_", "_.json"}));
        this.dataPath = path = this.syncJobService.createTempFile(filename);
        public final class _initJsonDataFile_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _initJsonDataFile_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object wr) {
                ((Writer)wr).write("[\n");
                return null;
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _initJsonDataFile_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        NioGroovyMethods.withWriter((Path)this.dataPath, (Closure)new _initJsonDataFile_closure3(this, this));
    }

    public List<Map> transformResults(ApiResults apiResults) {
        ICUMessageSource msgService = this.syncJobService.getMessageSource();
        List ret = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        boolean ok = true;
        Result r = null;
        Iterator iterator = apiResults.iterator();
        while (iterator.hasNext()) {
            r = (Result)ScriptBytecodeAdapter.castToType(iterator.next(), Result.class);
            Map map = ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ok", r.getOk(), "status", r.getStatus().getCode(), "data", r.getPayload()});
            if (r instanceof ProblemTrait) {
                map.putAll(ScriptBytecodeAdapter.createMap((Object[])new Object[]{"code", r.getCode(), "title", ResultUtils.getMessage((MsgService)msgService, (Result)r), "detail", ((ProblemTrait)ScriptBytecodeAdapter.castToType((Object)r, ProblemTrait.class)).getDetail(), "errors", ((ProblemTrait)ScriptBytecodeAdapter.castToType((Object)r, ProblemTrait.class)).getViolations()}));
            } else {
                Map map2 = (Map)ScriptBytecodeAdapter.asType((Object)r.getPayload(), Map.class);
                ScriptBytecodeAdapter.setProperty((Object)map2, null, (Object)map, (String)"data");
            }
            DefaultGroovyMethods.leftShift((List)ret, (Object)map);
        }
        return ret;
    }

    public Long writePayloadFile(Collection<Map> payload) {
        String filename = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.jobId}, new String[]{"SyncJobPayload_", "_.json"}));
        Path path = this.syncJobService.createTempFile(filename);
        JsonStreaming.streamToFile(payload, (Path)path);
        return this.syncJobService.createAttachment(path, filename);
    }

    public static BigDecimal getUsedMem() {
        int gb = 1024 * 1024 * 1024;
        Runtime runtime = Runtime.getRuntime();
        return (BigDecimal)ScriptBytecodeAdapter.castToType((Object)NumberNumberDiv.div((Number)(runtime.totalMemory() - runtime.freeMemory()), (Number)gb), BigDecimal.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != SyncJobContext.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public SyncJobContext ok(AtomicBoolean ok) {
        AtomicBoolean atomicBoolean;
        this.ok = atomicBoolean = ok;
        return this;
    }

    @Generated
    public SyncJobContext syncJobService(SyncJobService syncJobService) {
        SyncJobService syncJobService2;
        this.syncJobService = syncJobService2 = syncJobService;
        return this;
    }

    @Generated
    public SyncJobContext args(SyncJobArgs args) {
        SyncJobArgs syncJobArgs;
        this.args = syncJobArgs = args;
        return this;
    }

    @Generated
    public SyncJobContext results(ApiResults results) {
        ApiResults apiResults;
        this.results = apiResults = results;
        return this;
    }

    @Generated
    public SyncJobContext payload(Object payload) {
        Object object;
        this.payload = object = payload;
        return this;
    }

    @Generated
    public SyncJobContext payloadSize(int payloadSize) {
        int n;
        this.payloadSize = n = payloadSize;
        return this;
    }

    @Generated
    public SyncJobContext processedCount(AtomicInteger processedCount) {
        AtomicInteger atomicInteger;
        this.processedCount = atomicInteger = processedCount;
        return this;
    }

    @Generated
    public SyncJobContext problemCount(AtomicInteger problemCount) {
        AtomicInteger atomicInteger;
        this.problemCount = atomicInteger = problemCount;
        return this;
    }

    @Generated
    public SyncJobContext dataPath(Path dataPath) {
        Path path;
        this.dataPath = path = dataPath;
        return this;
    }

    @Generated
    public SyncJobContext jobId(Long jobId) {
        Long l;
        this.jobId = l = jobId;
        return this;
    }

    @Generated
    public String toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("gorm.tools.job.SyncJobContext(");
        Boolean bl = $toStringFirst;
        if (bl == null ? false : bl) {
            Boolean bl2;
            $toStringFirst = bl2 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getOk()));
        Boolean bl3 = $toStringFirst;
        if (bl3 == null ? false : bl3) {
            Boolean bl4;
            $toStringFirst = bl4 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getSyncJobService()));
        Boolean bl5 = $toStringFirst;
        if (bl5 == null ? false : bl5) {
            Boolean bl6;
            $toStringFirst = bl6 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getArgs()));
        Boolean bl7 = $toStringFirst;
        if (bl7 == null ? false : bl7) {
            Boolean bl8;
            $toStringFirst = bl8 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getResults()));
        Boolean bl9 = $toStringFirst;
        if (bl9 == null ? false : bl9) {
            Boolean bl10;
            $toStringFirst = bl10 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getPayload()));
        Boolean bl11 = $toStringFirst;
        if (bl11 == null ? false : bl11) {
            Boolean bl12;
            $toStringFirst = bl12 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getPayloadSize()));
        Boolean bl13 = $toStringFirst;
        if (bl13 == null ? false : bl13) {
            Boolean bl14;
            $toStringFirst = bl14 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getProcessedCount()));
        Boolean bl15 = $toStringFirst;
        if (bl15 == null ? false : bl15) {
            Boolean bl16;
            $toStringFirst = bl16 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getProblemCount()));
        Boolean bl17 = $toStringFirst;
        if (bl17 == null ? false : bl17) {
            Boolean bl18;
            $toStringFirst = bl18 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getDataPath()));
        Boolean bl19 = $toStringFirst;
        if (bl19 == null ? false : bl19) {
            Boolean bl20;
            $toStringFirst = bl20 = Boolean.FALSE;
        } else {
            _result.append(", ");
        }
        _result.append(InvokerHelper.toString((Object)this.getJobId()));
        _result.append(")");
        return _result.toString();
    }

    @Generated
    public static SyncJobContext create() {
        return SyncJobContext.create(ScriptBytecodeAdapter.createMap((Object[])new Object[0]));
    }

    @Generated
    public SyncJobEntity finishJob() {
        return this.finishJob(ScriptBytecodeAdapter.createList((Object[])new Object[0]));
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"gorm.tools.job.SyncJobContext");
    }

    @Generated
    public AtomicBoolean getOk() {
        return this.ok;
    }

    @Generated
    public void setOk(AtomicBoolean atomicBoolean) {
        this.ok = atomicBoolean;
    }

    @Generated
    public SyncJobService getSyncJobService() {
        return this.syncJobService;
    }

    @Generated
    public void setSyncJobService(SyncJobService syncJobService) {
        this.syncJobService = syncJobService;
    }

    @Generated
    public SyncJobArgs getArgs() {
        return this.args;
    }

    @Generated
    public void setArgs(SyncJobArgs syncJobArgs) {
        this.args = syncJobArgs;
    }

    @Generated
    public ApiResults getResults() {
        return this.results;
    }

    @Generated
    public void setResults(ApiResults apiResults) {
        this.results = apiResults;
    }

    @Generated
    public Object getPayload() {
        return this.payload;
    }

    @Generated
    public void setPayload(Object object) {
        this.payload = object;
    }

    @Generated
    public int getPayloadSize() {
        return this.payloadSize;
    }

    @Generated
    public AtomicInteger getProcessedCount() {
        return this.processedCount;
    }

    @Generated
    public void setProcessedCount(AtomicInteger atomicInteger) {
        this.processedCount = atomicInteger;
    }

    @Generated
    public AtomicInteger getProblemCount() {
        return this.problemCount;
    }

    @Generated
    public void setProblemCount(AtomicInteger atomicInteger) {
        this.problemCount = atomicInteger;
    }

    @Generated
    public Path getDataPath() {
        return this.dataPath;
    }

    @Generated
    public void setDataPath(Path path) {
        this.dataPath = path;
    }

    @Generated
    public Long getJobId() {
        return this.jobId;
    }

    @Generated
    public void setJobId(Long l) {
        this.jobId = l;
    }
}

