/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.jdbc;

import gorm.tools.beans.AppCtx;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbDialectService
implements GroovyObject {
    private static final int UNKNOWN = 0;
    private static final int MSSQL = 1;
    private static final int MYSQL = 2;
    private static final int ORACLE = 3;
    private static final int H2 = 4;
    private static final int POSTGRESQL = 5;
    private JdbcTemplate jdbcTemplate;
    private static String dialectName;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DbDialectService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    private static int setupDialect() {
        int result = UNKNOWN;
        if (!DefaultTypeTransformation.booleanUnbox((Object)dialectName)) {
            String string;
            dialectName = string = AppCtx.getConfig().getProperty("hibernate.dialect");
        }
        if (dialectName == null && ClassUtils.isPresent((String)"org.h2.Driver") || dialectName.contains("H2")) {
            int n;
            result = n = H2;
        } else if (dialectName.contains("SQLServerDialect")) {
            int n;
            result = n = MSSQL;
        } else if (dialectName.matches(".*SQLServer20\\d\\dDialect")) {
            int n;
            result = n = MSSQL;
        } else if (dialectName.contains("MySQL5InnoDBDialect")) {
            int n;
            result = n = MYSQL;
        } else if (dialectName.contains("Oracle")) {
            int n;
            result = n = ORACLE;
        } else if (dialectName.contains("Postgre")) {
            int n;
            result = n = POSTGRESQL;
        }
        if (result == UNKNOWN) {
            throw (Throwable)new SQLException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{dialectName}, new String[]{"Unknown dialect ", " in gorm.tools.jdbc.DbDialectService.\n"}).plus("Please specify a known for for config hibernate.dialect")));
        }
        return result;
    }

    public int getDialect() {
        return DbDialectService.setupDialect();
    }

    public String getCurrentDate() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String date = null;
        Integer n = this.getDialect();
        date = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? (string6 = "getdate()") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? (string5 = "now()") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? (string4 = "SYSDATE") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)H2) ? (string3 = "CURRENT_DATE()") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? (string2 = "now()") : (string = "now()")))));
        return date;
    }

    public String getIfNull() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String ifnull = null;
        Integer n = this.getDialect();
        ifnull = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? (string5 = "isnull") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? (string4 = "ifnull") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? (string3 = "NVL") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? (string2 = "COALESCE") : (string = "ifnull"))));
        return ifnull;
    }

    public String getConcat() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String concat = null;
        Integer n = this.getDialect();
        concat = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? (string6 = "+") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? (string5 = "+") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? (string4 = "||") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)H2) ? (string3 = "||") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? (string2 = "||") : (string = "+")))));
        return concat;
    }

    public String getCharFn() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String charFn = null;
        Integer n = this.getDialect();
        charFn = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? (string5 = "CHAR") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? (string4 = "CHAR") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? (string3 = "CHR") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? (string2 = "CHAR") : (string = "CHAR"))));
        return charFn;
    }

    public String getSubstringFn() {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String substringFn = null;
        Integer n = this.getDialect();
        substringFn = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? (string5 = "SUBSTRING") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? (string4 = "SUBSTRING") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? (string3 = "SUBSTR") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? (string2 = "SUBSTRING") : (string = "SUBSTRING"))));
        return substringFn;
    }

    public String datediff(Object upperDate, Object lowerDate) {
        String func;
        block1: {
            Integer n;
            block2: {
                block0: {
                    func = null;
                    n = this.getDialect();
                    if (!ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL)) break block0;
                    GStringImpl gStringImpl = new GStringImpl(new Object[]{lowerDate, upperDate}, new String[]{"DATEDIFF(dd, ", ", ", ")"});
                    func = ShortTypeHandling.castToString((Object)gStringImpl);
                    break block1;
                }
                if (!ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL)) break block2;
                GStringImpl gStringImpl = new GStringImpl(new Object[]{upperDate, lowerDate}, new String[]{"DATEDIFF(", ", ", ")"});
                func = ShortTypeHandling.castToString((Object)gStringImpl);
                break block1;
            }
            if (!ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL)) break block1;
            GStringImpl gStringImpl = new GStringImpl(new Object[]{upperDate, lowerDate}, new String[]{"date_part('day', ", " - ", " )"});
            func = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return func;
    }

    public String getDialectName() {
        return DbDialectService.getSimpleDialectName(this.getDialect());
    }

    public String getTop(int num) {
        String top = null;
        Integer n = this.getDialect();
        if (ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{num}, new String[]{"TOP ", ""});
            top = ShortTypeHandling.castToString((Object)gStringImpl);
        } else if (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{num}, new String[]{"LIMIT ", ""});
            top = ShortTypeHandling.castToString((Object)gStringImpl);
        } else if (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{num}, new String[]{"ROWNUM <=", ""});
            top = ShortTypeHandling.castToString((Object)gStringImpl);
        } else if (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL)) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{num}, new String[]{"fetch first ", " rows only"});
            top = ShortTypeHandling.castToString((Object)gStringImpl);
        } else {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{num}, new String[]{"LIMIT ", ""});
            top = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return top;
    }

    public void updateOrDateFormat() {
        if (this.getDialect() == ORACLE) {
            String alterOrDateFormat = "alter session set nls_date_format = 'YYYY-MM-dd hh24:mi:ss'";
            this.jdbcTemplate.update(alterOrDateFormat);
        }
    }

    public String getDateFormatForDialect(Object myDate) {
        CallSite[] callSiteArray = DbDialectService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[0].callCurrent((GroovyObject)this)) == ORACLE) {
                Date dateobj = null;
                if (myDate instanceof String) {
                    Object object = callSiteArray[1].callConstructor(Date.class, myDate);
                    dateobj = (Date)ScriptBytecodeAdapter.castToType((Object)object, Date.class);
                } else {
                    Object object = myDate;
                    dateobj = (Date)ScriptBytecodeAdapter.castToType((Object)object, Date.class);
                }
                String formattedDate = ShortTypeHandling.castToString((Object)callSiteArray[2].call((Object)dateobj, (Object)"yyyy-MM-dd hh:mm:ss"));
                return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{formattedDate}, new String[]{" to_date (' ", " ', 'YYYY-MM-dd hh24:mi:ss')"}));
            }
        } else if (this.getDialect() == ORACLE) {
            Date dateobj = null;
            if (myDate instanceof String) {
                Object object = callSiteArray[3].callConstructor(Date.class, myDate);
                dateobj = (Date)ScriptBytecodeAdapter.castToType((Object)object, Date.class);
            } else {
                Object object = myDate;
                dateobj = (Date)ScriptBytecodeAdapter.castToType((Object)object, Date.class);
            }
            String formattedDate = ShortTypeHandling.castToString((Object)callSiteArray[4].call((Object)dateobj, (Object)"yyyy-MM-dd hh:mm:ss"));
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{formattedDate}, new String[]{" to_date (' ", " ', 'YYYY-MM-dd hh24:mi:ss')"}));
        }
        return ShortTypeHandling.castToString((Object)myDate);
    }

    public static String getSimpleDialectName(int dialectKey) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String dialectName = null;
        Integer n = dialectKey;
        dialectName = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? (string6 = "mssql") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? (string5 = "mysql") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? (string4 = "oracle") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)H2) ? (string3 = "h2") : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? (string2 = "postgresql") : (string = "mysql")))));
        return dialectName;
    }

    public static Map getGlobalVariables() {
        LinkedHashMap result = (LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), LinkedHashMap.class);
        int dialect = DbDialectService.setupDialect();
        String dialectName = DbDialectService.getSimpleDialectName(dialect);
        String string = dialectName;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)result, (String)"dialect");
        return result;
    }

    public boolean isMySql() {
        return this.getDialect() == MYSQL;
    }

    public boolean isMsSql() {
        return this.getDialect() == MSSQL;
    }

    public boolean isH2() {
        return this.getDialect() == H2;
    }

    public boolean isPostgres() {
        return this.getDialect() == POSTGRESQL;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DbDialectService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public static int getUNKNOWN() {
        return UNKNOWN;
    }

    @Generated
    public static int getMSSQL() {
        return MSSQL;
    }

    @Generated
    public static int getMYSQL() {
        return MYSQL;
    }

    @Generated
    public static int getORACLE() {
        return ORACLE;
    }

    @Generated
    public static int getH2() {
        return H2;
    }

    @Generated
    public static int getPOSTGRESQL() {
        return POSTGRESQL;
    }

    @Generated
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Generated
    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Generated
    public static void setDialectName(String string) {
        dialectName = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getDialect";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "format";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "format";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[5];
        DbDialectService.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DbDialectService.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DbDialectService.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

