/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.problem;

import gorm.tools.problem.ValidationProblem;
import gorm.tools.repository.errors.EmptyErrors;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StackTraceUtils;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.datastore.mapping.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.core.NestedRuntimeException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import yakworks.api.ApiStatus;
import yakworks.api.HttpStatus;
import yakworks.api.problem.GenericProblem;
import yakworks.api.problem.Problem;
import yakworks.api.problem.ProblemResult;
import yakworks.api.problem.ThrowableProblem;
import yakworks.api.problem.UnexpectedProblem;
import yakworks.api.problem.Violation;
import yakworks.api.problem.ViolationFieldError;
import yakworks.api.problem.data.DataProblem;
import yakworks.api.problem.data.DataProblemCodes;
import yakworks.i18n.icu.ICUMessageSource;

public class ProblemHandler
implements GroovyObject {
    @Autowired
    private ICUMessageSource messageSource;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public ProblemHandler() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public GenericProblem handleException(Class entityClass, Throwable e) {
        return this.handleException(e, entityClass.getSimpleName());
    }

    public GenericProblem handleException(Throwable e, String simpleName) {
        HttpStatus status400 = HttpStatus.BAD_REQUEST;
        HttpStatus status404 = HttpStatus.NOT_FOUND;
        HttpStatus status422 = HttpStatus.UNPROCESSABLE_ENTITY;
        if (e instanceof ValidationProblem.Exception) {
            ValidationProblem valProblem = ((ValidationProblem.Exception)((Object)ScriptBytecodeAdapter.castToType((Object)e, ValidationProblem.Exception.class))).getValidationProblem();
            if (valProblem.getErrors() instanceof EmptyErrors) {
                Throwable throwable = e.getCause();
                valProblem.detail(throwable != null ? throwable.getMessage() : null);
            }
            valProblem.violations(this.transateErrorsToViolations(valProblem.getErrors()));
            return valProblem;
        }
        if (e instanceof ThrowableProblem) {
            return ((ThrowableProblem)ScriptBytecodeAdapter.castToType((Object)e, ThrowableProblem.class)).getProblem();
        }
        if (e instanceof GenericProblem) {
            return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)e, GenericProblem.class);
        }
        if (e instanceof grails.validation.ValidationException || e instanceof ValidationException) {
            return this.buildFromErrorException(e, simpleName);
        }
        if (e instanceof IllegalArgumentException) {
            return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)((ProblemResult)Problem.of((String)"error.illegalArgument").status((ApiStatus)status400)).detail(e.getMessage()), GenericProblem.class);
        }
        if (e instanceof DataAccessException) {
            Object v0;
            if (DefaultTypeTransformation.booleanUnbox((Object)ProblemHandler.isUniqueIndexViolation((DataAccessException)ScriptBytecodeAdapter.castToType((Object)e, DataAccessException.class)))) {
                return DataProblemCodes.UniqueConstraint.of(e);
            }
            Throwable throwable = ((NestedRuntimeException)ScriptBytecodeAdapter.castToType((Object)e, NestedRuntimeException.class)).getRootCause();
            String rootMessage = throwable != null ? throwable.getMessage() : null;
            String msgInfo = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage(), rootMessage}, new String[]{"===  message: ", " \n === rootMessage: ", " "}));
            if (log.isErrorEnabled()) {
                log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{msgInfo}, new String[]{"MAYBE UNEXPECTED? Data Access Exception ", ""})), StackTraceUtils.deepSanitize((Throwable)e));
                v0 = null;
            } else {
                v0 = null;
            }
            return DataProblem.of((Throwable)e);
        }
        return this.handleUnexpected(e);
    }

    public GenericProblem handleUnexpected(Throwable e) {
        Object v0;
        if (log.isErrorEnabled()) {
            log.error(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{e.getMessage()}, new String[]{"UNEXPECTED Internal Server Error\n", ""})), StackTraceUtils.deepSanitize((Throwable)e));
            v0 = null;
        } else {
            v0 = null;
        }
        if (e instanceof GenericProblem) {
            return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)e, GenericProblem.class);
        }
        if (e instanceof ThrowableProblem) {
            return ((ThrowableProblem)ScriptBytecodeAdapter.castToType((Object)e, ThrowableProblem.class)).getProblem();
        }
        return (GenericProblem)ScriptBytecodeAdapter.castToType((Object)((UnexpectedProblem)new UnexpectedProblem().cause(e)).detail(e.getMessage()), GenericProblem.class);
    }

    public ValidationProblem buildFromErrorException(Throwable valEx, String entityName) {
        Errors ers = (Errors)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)valEx, (String)"errors"), Errors.class);
        ValidationProblem valProb = ValidationProblem.of(valEx).errors(ers);
        if (DefaultTypeTransformation.booleanUnbox((Object)entityName)) {
            valProb.name(entityName);
        }
        return (ValidationProblem)ScriptBytecodeAdapter.castToType((Object)valProb.violations(this.transateErrorsToViolations(ers)), ValidationProblem.class);
    }

    public String getMsg(MessageSourceResolvable msr) {
        String string = this.messageSource.getMessage(msr);
        try {
            return string;
        }
        catch (Exception e) {
            String string2 = ShortTypeHandling.castToString((Object)BytecodeInterface8.objectArrayGet((Object[])msr.getCodes(), (int)0));
            return string2;
        }
    }

    public List<Violation> transateErrorsToViolations(Errors errs) {
        List errors = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        Errors errors2 = errs;
        if (!DefaultTypeTransformation.booleanUnbox((Object)(errors2 != null ? errors2.getAllErrors() : null))) {
            return errors;
        }
        ObjectError err = null;
        Iterator iterator = errs.getAllErrors().iterator();
        while (iterator.hasNext()) {
            err = (ObjectError)ScriptBytecodeAdapter.castToType(iterator.next(), ObjectError.class);
            ViolationFieldError fieldError = ViolationFieldError.of((String)err.getCode(), (String)this.getMsg((MessageSourceResolvable)err));
            if (err instanceof FieldError) {
                String string;
                ((FieldError)ScriptBytecodeAdapter.castToType((Object)err, FieldError.class)).getField();
                fieldError.setField(string);
            }
            DefaultGroovyMethods.leftShift((List)errors, (Object)fieldError);
        }
        return errors;
    }

    public static String isUniqueIndexViolation(DataAccessException dax) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)dax.getRootCause())) {
            return ShortTypeHandling.castToString(null);
        }
        String rootMessage = dax.getRootCause().getMessage();
        if (rootMessage.contains("Unique index or primary key violation") || rootMessage.contains("Duplicate entry") || rootMessage.contains("Violation of UNIQUE KEY constraint") || rootMessage.contains("unique constraint")) {
            return rootMessage;
        }
        return ShortTypeHandling.castToString(null);
    }

    public static String isForeignKeyViolation(DataAccessException dax) {
        if (!DefaultTypeTransformation.booleanUnbox((Object)dax.getRootCause()) || !(dax instanceof DataIntegrityViolationException)) {
            return ShortTypeHandling.castToString(null);
        }
        String rootMessage = dax.getRootCause().getMessage().toLowerCase();
        if (rootMessage.contains("foreign key")) {
            return rootMessage;
        }
        return ShortTypeHandling.castToString(null);
    }

    public static Object isBrokenPipe(Exception ex) {
        return ex.getMessage().toLowerCase().contains("broken pipe");
    }

    public static String formatErrors(Errors errors, String msg) {
        String ls = System.getProperty("line.separator");
        StringBuilder b = new StringBuilder();
        if (msg != null) {
            b.append(msg).append(" : ");
        }
        ObjectError error = null;
        Iterator iterator = errors.getAllErrors().iterator();
        while (iterator.hasNext()) {
            error = (ObjectError)ScriptBytecodeAdapter.castToType(iterator.next(), ObjectError.class);
            b.append(ls).append(" - ").append(error).append(ls);
        }
        return b.toString();
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProblemHandler.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    public GenericProblem handleException(Throwable e) {
        CallSite[] callSiteArray = ProblemHandler.$getCallSiteArray();
        return this.handleException(e, null);
    }

    @Generated
    public ValidationProblem buildFromErrorException(Throwable valEx) {
        CallSite[] callSiteArray = ProblemHandler.$getCallSiteArray();
        return this.buildFromErrorException(valEx, null);
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"gorm.tools.problem.ProblemHandler");
    }

    @Generated
    public ICUMessageSource getMessageSource() {
        return this.messageSource;
    }

    @Generated
    public void setMessageSource(ICUMessageSource iCUMessageSource) {
        this.messageSource = iCUMessageSource;
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(ProblemHandler.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProblemHandler.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

