/*
 * Decompiled with CFR 0.152.
 */
package gorm.tools.jdbc;

import groovy.lang.GeneratedGroovyProxy;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.codehaus.groovy.transform.trait.Traits;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import yakworks.spring.SpringEnvironment;

public class DbDialectService
implements SpringEnvironment,
GroovyObject,
SpringEnvironment.Trait.FieldHelper {
    private static final int UNKNOWN = 0;
    private static final int MSSQL = 1;
    private static final int MYSQL = 2;
    private static final int ORACLE = 3;
    private static final int H2 = 4;
    private static final int POSTGRESQL = 5;
    private static String hibernateDialect;
    private static int dialect;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final transient Logger log;
    private Environment yakworks_spring_SpringEnvironment__environment;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DbDialectService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        SpringEnvironment.Trait.Helper.$init$((SpringEnvironment)this);
    }

    @PostConstruct
    public void init() {
        String hibDialect = this.getEnvironment().getProperty("hibernate.dialect");
        if (DefaultTypeTransformation.booleanUnbox((Object)hibDialect)) {
            String string;
            hibernateDialect = string = hibDialect;
        }
        if (!(dialect != 0)) {
            DbDialectService.init(hibernateDialect);
        }
    }

    public static int init(String hibernateDialectName) {
        int n;
        if (!DefaultTypeTransformation.booleanUnbox((Object)hibernateDialectName)) {
            hibernateDialectName = "H2";
            if (!ClassUtils.isPresent((String)"org.h2.Driver", (ClassLoader)DbDialectService.class.getClassLoader())) {
                log.error("no hibernateDialect set, defaulting to H2 but org.h2.Driver doesnt appear on the classpath.");
            }
        }
        String string = hibernateDialectName;
        ScriptBytecodeAdapter.setProperty((Object)string, null, DbDialectService.class, (String)"hibernateDialect");
        int result = UNKNOWN;
        if (hibernateDialectName.contains("H2")) {
            result = H2;
        } else if (hibernateDialectName.contains("SQLServerDialect")) {
            result = MSSQL;
        } else if (hibernateDialectName.matches(".*SQLServer20\\d\\dDialect")) {
            result = MSSQL;
        } else if (hibernateDialectName.contains("MySQL5InnoDBDialect")) {
            result = MYSQL;
        } else if (hibernateDialectName.contains("Oracle")) {
            result = ORACLE;
        } else if (hibernateDialectName.contains("Postgre")) {
            result = POSTGRESQL;
        }
        if (result == UNKNOWN) {
            throw (Throwable)new SQLException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{hibernateDialectName}, new String[]{"Unknown dialect ", " in gorm.tools.jdbc.DbDialectService.\n"}).plus("Please specify a known for for config hibernate.dialect")));
        }
        dialect = n = result;
        return dialect;
    }

    public String getCurrentDate() {
        String date = null;
        Integer n = dialect;
        date = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? "getdate()" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? "now()" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? "SYSDATE" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)H2) ? "CURRENT_DATE()" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? "now()" : "now()"))));
        return date;
    }

    public String getIfNull() {
        String ifnull = null;
        Integer n = dialect;
        ifnull = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? "isnull" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? "ifnull" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? "NVL" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? "COALESCE" : "ifnull")));
        return ifnull;
    }

    public String getConcat() {
        String concat = null;
        Integer n = dialect;
        concat = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? "+" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? "+" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? "||" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)H2) ? "||" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? "||" : "+"))));
        return concat;
    }

    public String getCharFn() {
        String charFn = null;
        Integer n = dialect;
        charFn = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? "CHAR" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? "CHAR" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? "CHR" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? "CHAR" : "CHAR")));
        return charFn;
    }

    public String getSubstringFn() {
        String substringFn = null;
        Integer n = dialect;
        substringFn = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? "SUBSTRING" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? "SUBSTRING" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? "SUBSTR" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? "SUBSTRING" : "SUBSTRING")));
        return substringFn;
    }

    public String datediff(Object upperDate, Object lowerDate) {
        String func;
        block1: {
            Integer n;
            block2: {
                block0: {
                    func = null;
                    n = dialect;
                    if (!ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL)) break block0;
                    func = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{lowerDate, upperDate}, new String[]{"DATEDIFF(dd, ", ", ", ")"}));
                    break block1;
                }
                if (!ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL)) break block2;
                func = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{upperDate, lowerDate}, new String[]{"DATEDIFF(", ", ", ")"}));
                break block1;
            }
            if (!ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL)) break block1;
            func = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{upperDate, lowerDate}, new String[]{"date_part('day', ", " - ", " )"}));
        }
        return func;
    }

    public static String getDialectName() {
        return DbDialectService.getSimpleDialectName(dialect);
    }

    public String getTop(int num) {
        String top = null;
        Integer n = dialect;
        top = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{num}, new String[]{"TOP ", ""})) : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{num}, new String[]{"LIMIT ", ""})) : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{num}, new String[]{"ROWNUM <=", ""})) : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{num}, new String[]{"fetch first ", " rows only"})) : ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{num}, new String[]{"LIMIT ", ""})))));
        return top;
    }

    public void updateOracleDateFormat() {
        if (dialect == ORACLE) {
            String alterOrDateFormat = "alter session set nls_date_format = 'YYYY-MM-dd hh24:mi:ss'";
        }
    }

    public String getDateFormatForDialect(Object myDate) {
        CallSite[] callSiteArray = DbDialectService.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (DefaultTypeTransformation.intUnbox((Object)callSiteArray[0].callStatic(DbDialectService.class)) == ORACLE) {
                Date dateobj = null;
                dateobj = myDate instanceof String ? (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callConstructor(Date.class, myDate), Date.class) : (Date)ScriptBytecodeAdapter.castToType((Object)myDate, Date.class);
                String formattedDate = ShortTypeHandling.castToString((Object)callSiteArray[2].call((Object)dateobj, (Object)"yyyy-MM-dd hh:mm:ss"));
                return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{formattedDate}, new String[]{" to_date (' ", " ', 'YYYY-MM-dd hh24:mi:ss')"}));
            }
        } else if (DbDialectService.getDialect() == ORACLE) {
            Date dateobj = null;
            dateobj = myDate instanceof String ? (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(Date.class, myDate), Date.class) : (Date)ScriptBytecodeAdapter.castToType((Object)myDate, Date.class);
            String formattedDate = ShortTypeHandling.castToString((Object)callSiteArray[4].call((Object)dateobj, (Object)"yyyy-MM-dd hh:mm:ss"));
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{formattedDate}, new String[]{" to_date (' ", " ', 'YYYY-MM-dd hh24:mi:ss')"}));
        }
        return ShortTypeHandling.castToString((Object)myDate);
    }

    public static String getSimpleDialectName(int dialectKey) {
        String simpleName = null;
        Integer n = dialectKey;
        simpleName = ScriptBytecodeAdapter.isCase((Object)n, (Object)MSSQL) ? "mssql" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)MYSQL) ? "mysql" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)ORACLE) ? "oracle" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)H2) ? "h2" : (ScriptBytecodeAdapter.isCase((Object)n, (Object)POSTGRESQL) ? "postgresql" : "mysql"))));
        return simpleName;
    }

    public static Map getGlobalVariables() {
        return ScriptBytecodeAdapter.createMap((Object[])new Object[]{"dialect", DbDialectService.getDialectName()});
    }

    public boolean isMySql() {
        return dialect == MYSQL;
    }

    public boolean isMsSql() {
        return dialect == MSSQL;
    }

    public boolean isH2() {
        return dialect == H2;
    }

    public boolean isPostgres() {
        return dialect == POSTGRESQL;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DbDialectService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Traits.TraitBridge(traitClass=SpringEnvironment.class, desc="()Lorg/springframework/core/env/Environment;")
    public Environment getConfig() {
        return SpringEnvironment.Trait.Helper.getConfig((SpringEnvironment)this);
    }

    @Generated
    public /* synthetic */ Environment yakworks_spring_SpringEnvironmenttrait$super$getConfig() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Environment)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getConfig", (Object)new Object[0]), Environment.class);
        }
        return (Environment)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getConfig"), Environment.class);
    }

    @Traits.TraitBridge(traitClass=SpringEnvironment.class, desc="(Lorg/springframework/core/env/Environment;)V")
    public void setEnvironment(Environment arg1) {
        SpringEnvironment.Trait.Helper.setEnvironment((SpringEnvironment)this, (Environment)arg1);
    }

    @Generated
    public /* synthetic */ void yakworks_spring_SpringEnvironmenttrait$super$setEnvironment(Environment param0) {
        if (this instanceof GeneratedGroovyProxy) {
            void cfr_ignored_0 = (void)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"setEnvironment", (Object)new Object[]{param0});
        } else {
            ScriptBytecodeAdapter.invokeMethodOnSuperN(Object.class, (GroovyObject)this, (String)"setEnvironment", (Object[])new Object[]{param0});
        }
    }

    @Generated
    @Traits.TraitBridge(traitClass=SpringEnvironment.class, desc="()Lorg/springframework/core/env/Environment;")
    public Environment getEnvironment() {
        return SpringEnvironment.Trait.Helper.getEnvironment((SpringEnvironment)this);
    }

    @Generated
    public /* synthetic */ Environment yakworks_spring_SpringEnvironmenttrait$super$getEnvironment() {
        if (this instanceof GeneratedGroovyProxy) {
            return (Environment)ScriptBytecodeAdapter.castToType((Object)InvokerHelper.invokeMethod((Object)((GeneratedGroovyProxy)ScriptBytecodeAdapter.castToType((Object)this, GeneratedGroovyProxy.class)).getProxyTarget(), (String)"getEnvironment", (Object)new Object[0]), Environment.class);
        }
        return (Environment)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.invokeMethodOnSuper0(Object.class, (GroovyObject)this, (String)"getEnvironment"), Environment.class);
    }

    static {
        Logger logger;
        int n;
        dialect = n = 0;
        log = logger = LoggerFactory.getLogger((String)"gorm.tools.jdbc.DbDialectService");
        SpringEnvironment.Trait.Helper.$static$init$(DbDialectService.class);
    }

    @Generated
    public /* synthetic */ Environment yakworks_spring_SpringEnvironment__environment$get() {
        return this.yakworks_spring_SpringEnvironment__environment;
    }

    @Generated
    public /* synthetic */ Environment yakworks_spring_SpringEnvironment__environment$set(Environment val) {
        Environment environment;
        this.yakworks_spring_SpringEnvironment__environment = environment = val;
        return environment;
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    public static int getUNKNOWN() {
        return UNKNOWN;
    }

    @Generated
    public static int getMSSQL() {
        return MSSQL;
    }

    @Generated
    public static int getMYSQL() {
        return MYSQL;
    }

    @Generated
    public static int getORACLE() {
        return ORACLE;
    }

    @Generated
    public static int getH2() {
        return H2;
    }

    @Generated
    public static int getPOSTGRESQL() {
        return POSTGRESQL;
    }

    @Generated
    public static String getHibernateDialect() {
        return hibernateDialect;
    }

    @Generated
    public static void setHibernateDialect(String string) {
        hibernateDialect = string;
    }

    @Generated
    public static int getDialect() {
        return dialect;
    }

    @Generated
    public static void setDialect(int n) {
        dialect = n;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "getDialect";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "format";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "format";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[5];
        DbDialectService.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DbDialectService.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DbDialectService.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

