/*
 * Decompiled with CFR 0.152.
 */
package yakworks.commons.lang;

import java.util.HashMap;
import java.util.Map;
import yakworks.commons.util.StringUtils;

public class AssignUtils {
    public static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_COMPATIBLE_CLASSES = new HashMap();

    private static void registerPrimitiveClassPair(Class<?> left, Class<?> right) {
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(left, right);
        PRIMITIVE_TYPE_COMPATIBLE_CLASSES.put(right, left);
    }

    public static boolean isAssignableFrom(Class<?> leftType, Class<?> rightType) {
        boolean result;
        if (leftType == null) {
            throw new NullPointerException("Left type is null!");
        }
        if (rightType == null) {
            throw new NullPointerException("Right type is null!");
        }
        if (leftType == Object.class) {
            return true;
        }
        if (leftType == rightType) {
            return true;
        }
        Class<?> r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(leftType);
        boolean bl = result = r == rightType;
        if (!result) {
            if (rightType.isPrimitive()) {
                r = PRIMITIVE_TYPE_COMPATIBLE_CLASSES.get(rightType);
                if (r != null) {
                    result = leftType.isAssignableFrom(r);
                }
            } else {
                result = leftType.isAssignableFrom(rightType);
            }
        }
        return result;
    }

    public static boolean isGetter(String name, Class<?>[] args) {
        if (!StringUtils.hasText(name) || args == null) {
            return false;
        }
        if (args.length != 0) {
            return false;
        }
        return name.startsWith("get") ? (name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0)) : name.startsWith("is") && (name = name.substring(2)).length() > 0 && Character.isUpperCase(name.charAt(0));
    }

    public static boolean isSetter(String name, Class[] args) {
        if (!StringUtils.hasText(name) || args == null) {
            return false;
        }
        if (name.startsWith("set")) {
            if (args.length != 1) {
                return false;
            }
            if ((name = name.substring(3)).length() > 0 && Character.isUpperCase(name.charAt(0))) {
                return true;
            }
        }
        return false;
    }

    static {
        AssignUtils.registerPrimitiveClassPair(Boolean.class, Boolean.TYPE);
        AssignUtils.registerPrimitiveClassPair(Integer.class, Integer.TYPE);
        AssignUtils.registerPrimitiveClassPair(Short.class, Short.TYPE);
        AssignUtils.registerPrimitiveClassPair(Byte.class, Byte.TYPE);
        AssignUtils.registerPrimitiveClassPair(Character.class, Character.TYPE);
        AssignUtils.registerPrimitiveClassPair(Long.class, Long.TYPE);
        AssignUtils.registerPrimitiveClassPair(Float.class, Float.TYPE);
        AssignUtils.registerPrimitiveClassPair(Double.class, Double.TYPE);
    }
}

