/*
 * Decompiled with CFR 0.152.
 */
package yakworks.security.rest;

import com.nimbusds.jwt.JWT;
import grails.plugin.springsecurity.rest.JwtService;
import grails.plugin.springsecurity.rest.token.AccessToken;
import grails.plugin.springsecurity.rest.token.generation.jwt.AbstractJwtTokenGenerator;
import grails.plugin.springsecurity.rest.token.storage.TokenNotFoundException;
import grails.plugin.springsecurity.rest.token.storage.TokenStorageService;
import groovy.lang.MetaClass;
import groovy.time.TimeCategory;
import groovy.time.TimeDuration;
import groovy.transform.Generated;
import java.util.Date;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;

public class RestAuthenticationProvider
extends grails.plugin.springsecurity.rest.RestAuthenticationProvider {
    @Autowired
    private TokenStorageService tokenStorageService;
    @Autowired
    private JwtService jwtService;
    private Boolean useJwt;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    @Generated
    public RestAuthenticationProvider() {
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.useJwt}, new String[]{"Use JWT: ", ""})));
        Assert.isInstanceOf(AccessToken.class, (Object)authentication, (String)"Only AccessToken is supported");
        AccessToken authenticationRequest = (AccessToken)ScriptBytecodeAdapter.asType((Object)authentication, AccessToken.class);
        AccessToken authenticationResult = new AccessToken(authenticationRequest.getAccessToken());
        if (DefaultTypeTransformation.booleanUnbox((Object)authenticationRequest.getAccessToken())) {
            AccessToken accessToken;
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{authenticationRequest.getAccessToken()}, new String[]{"Trying to validate token ", ""})));
            UserDetails userDetails = null;
            boolean isJwtToken = false;
            if (ScriptBytecodeAdapter.compareEqual((Object)((String)ScriptBytecodeAdapter.asType((Object)authenticationRequest.getDetails(), String.class)), (Object)"jwt")) {
                UserDetails userDetails2;
                boolean bl;
                isJwtToken = bl = true;
                userDetails = userDetails2 = this.tokenStorageService.loadUserByToken(authenticationRequest.getAccessToken());
            } else {
                UserDetails userDetails3;
                userDetails = userDetails3 = this.tokenStorageService.loadUserByToken(authenticationRequest.getAccessToken());
            }
            Integer expiration = null;
            JWT jwt = null;
            if (DefaultTypeTransformation.booleanUnbox((Object)this.useJwt) || isJwtToken) {
                JWT jWT;
                Date now = new Date();
                jwt = jWT = this.jwtService.parse(authenticationRequest.getAccessToken());
                Boolean bl = jwt.getJWTClaimsSet().getBooleanClaim(AbstractJwtTokenGenerator.getREFRESH_ONLY_CLAIM());
                if (bl == null ? false : bl) {
                    throw (Throwable)new TokenNotFoundException(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{authenticationRequest.getAccessToken()}, new String[]{"Token ", " is not valid"})));
                }
                Date expiry = jwt.getJWTClaimsSet().getExpirationTime();
                if (DefaultTypeTransformation.booleanUnbox((Object)expiry)) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{now, expiry}, new String[]{"Now is ", " and token expires at ", ""})));
                    TimeDuration timeDuration = TimeCategory.minus((Date)expiry, (Date)now);
                    int n = Math.round(DefaultTypeTransformation.floatUnbox((Object)ScriptBytecodeAdapter.asType((Object)NumberNumberDiv.div((Number)timeDuration.toMilliseconds(), (Number)1000), Float.TYPE)));
                    expiration = n;
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{expiration}, new String[]{"Expiration: ", ""})));
                }
            }
            authenticationResult = accessToken = new AccessToken(userDetails, userDetails.getAuthorities(), authenticationRequest.getAccessToken(), null, expiration, jwt, null);
            log.debug("Authentication result: {}", (Object)authenticationResult);
        }
        return authenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return AccessToken.class.isAssignableFrom(authentication);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RestAuthenticationProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"yakworks.security.rest.RestAuthenticationProvider");
    }

    @Generated
    public TokenStorageService getTokenStorageService() {
        return this.tokenStorageService;
    }

    @Generated
    public void setTokenStorageService(TokenStorageService tokenStorageService) {
        this.tokenStorageService = tokenStorageService;
    }

    @Generated
    public JwtService getJwtService() {
        return this.jwtService;
    }

    @Generated
    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }

    @Generated
    public Boolean getUseJwt() {
        return this.useJwt;
    }

    @Generated
    public void setUseJwt(Boolean bl) {
        this.useJwt = bl;
    }
}

