/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yarnandtail.andhow.Options;
import org.yarnandtail.andhow.api.AppFatalException;
import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.EffectiveName;
import org.yarnandtail.andhow.api.ExportGroup;
import org.yarnandtail.andhow.api.Exporter;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.NamingStrategy;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValueMap;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.internal.ConstructionDefinitionMutable;
import org.yarnandtail.andhow.internal.ConstructionProblem;
import org.yarnandtail.andhow.internal.ReportGenerator;
import org.yarnandtail.andhow.internal.RequirementProblem;
import org.yarnandtail.andhow.internal.ValueMapWithContextMutable;
import org.yarnandtail.andhow.name.CaseInsensitiveNaming;
import org.yarnandtail.andhow.util.AndHowUtil;

public class AndHowCore
implements ConstructionDefinition,
ValueMap {
    private final List<Loader> loaders = new ArrayList<Loader>();
    private final ConstructionDefinition runtimeDef;
    private final ValueMapWithContext loadedValues;
    private final ProblemList<Problem> problems = new ProblemList();

    public AndHowCore(NamingStrategy naming, List<Loader> loaders, List<Class<? extends BasePropertyGroup>> registeredGroups) throws AppFatalException {
        NamingStrategy namingStrategy;
        NamingStrategy namingStrategy2 = namingStrategy = naming != null ? naming : new CaseInsensitiveNaming();
        if (loaders != null) {
            for (Loader loader : loaders) {
                if (!this.loaders.contains(loader)) {
                    this.loaders.add(loader);
                    continue;
                }
                this.problems.add(new ConstructionProblem.DuplicateLoader(loader));
            }
        }
        ArrayList<Class<? extends BasePropertyGroup>> effRegGroups = new ArrayList<Class<? extends BasePropertyGroup>>();
        if (registeredGroups != null) {
            effRegGroups.addAll(registeredGroups);
        }
        effRegGroups.add(Options.class);
        ConstructionDefinitionMutable startupDef = AndHowUtil.buildDefinition(effRegGroups, loaders, namingStrategy, this.problems);
        this.runtimeDef = startupDef.toImmutable();
        if (this.problems.size() > 0) {
            AppFatalException afe = new AppFatalException("There is a problem with the basic setup of the AndHow framework. Since it is the framework itself that is misconfigured, no attempt was made to load values. See System.err, out or the log files for more details.", this.problems);
            this.printFailedStartupDetails(afe);
            throw afe;
        }
        this.loadedValues = this.loadValues(this.runtimeDef, this.problems).getValueMapWithContextImmutable();
        this.checkForRequiredValues(this.runtimeDef, this.problems);
        if (this.problems.size() > 0) {
            AppFatalException afe = AndHowUtil.buildFatalException(this.problems);
            this.printFailedStartupDetails(afe);
            throw afe;
        }
        List<ExportGroup> exportGroups = this.runtimeDef.getExportGroups();
        for (ExportGroup eg : exportGroups) {
            Exporter exporter = eg.getExporter();
            Class<? extends BasePropertyGroup> group = eg.getGroup();
            if (group != null) {
                exporter.export(group, this.runtimeDef, this);
                continue;
            }
            for (Class<? extends BasePropertyGroup> grp : this.runtimeDef.getPropertyGroups()) {
                exporter.export(grp, this.runtimeDef, this);
            }
        }
        if (Options.CREATE_SAMPLES.getValue(this).booleanValue()) {
            ReportGenerator.printConfigSamples(this.runtimeDef, System.out, loaders, false);
        }
    }

    private void printFailedStartupDetails(AppFatalException afe) {
        ReportGenerator.printProblems(System.err, afe, this.runtimeDef);
        ReportGenerator.printConfigSamples(this.runtimeDef, System.err, this.loaders, true);
    }

    @Override
    public boolean isExplicitlySet(Property<?> prop) {
        return this.loadedValues.isExplicitlySet(prop);
    }

    @Override
    public <T> T getExplicitValue(Property<T> prop) {
        return this.loadedValues.getExplicitValue(prop);
    }

    @Override
    public <T> T getEffectiveValue(Property<T> prop) {
        return this.loadedValues.getEffectiveValue(prop);
    }

    private ValueMapWithContext loadValues(ConstructionDefinition definition, ProblemList<Problem> problems) {
        ValueMapWithContextMutable existingValues = new ValueMapWithContextMutable();
        for (Loader loader : this.loaders) {
            LoaderValues result = loader.load(definition, existingValues);
            existingValues.addValues(result);
            problems.addAll(result.getProblems());
        }
        return existingValues;
    }

    private void checkForRequiredValues(ConstructionDefinition definition, ProblemList<Problem> problems) {
        for (Property<?> prop : definition.getProperties()) {
            if (!prop.isRequired() || this.getEffectiveValue(prop) != null) continue;
            problems.add(new RequirementProblem.RequiredPropertyProblem(definition.getGroupForProperty(prop), prop));
        }
    }

    @Override
    public List<EffectiveName> getAliases(Property<?> property) {
        return this.runtimeDef.getAliases(property);
    }

    @Override
    public String getCanonicalName(Property<?> prop) {
        return this.runtimeDef.getCanonicalName(prop);
    }

    @Override
    public Class<? extends BasePropertyGroup> getGroupForProperty(Property<?> prop) {
        return this.runtimeDef.getGroupForProperty(prop);
    }

    @Override
    public List<Property<?>> getPropertiesForGroup(Class<? extends BasePropertyGroup> group) {
        return this.runtimeDef.getPropertiesForGroup(group);
    }

    @Override
    public Property<?> getProperty(String name) {
        return this.runtimeDef.getProperty(name);
    }

    @Override
    public List<Class<? extends BasePropertyGroup>> getPropertyGroups() {
        return this.runtimeDef.getPropertyGroups();
    }

    @Override
    public List<Property<?>> getProperties() {
        return this.runtimeDef.getProperties();
    }

    @Override
    public List<ExportGroup> getExportGroups() {
        return this.runtimeDef.getExportGroups();
    }

    @Override
    public NamingStrategy getNamingStrategy() {
        return this.runtimeDef.getNamingStrategy();
    }

    @Override
    public Map<String, String> getSystemEnvironment() {
        return this.runtimeDef.getSystemEnvironment();
    }
}

