/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.Validator;
import org.yarnandtail.andhow.internal.PropertyCoord;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class ConstructionProblem
implements Problem {
    protected PropertyCoord badPropertyCoord;
    protected PropertyCoord refPropertyCoord;

    public PropertyCoord getRefPropertyCoord() {
        return this.refPropertyCoord;
    }

    public PropertyCoord getBadPropertyCoord() {
        return this.badPropertyCoord;
    }

    @Override
    public String getProblemContext() {
        if (this.badPropertyCoord != null) {
            return TextUtil.format("Property {}", this.badPropertyCoord.getPropName());
        }
        return "[[Unknown]]";
    }

    @Override
    public String getFullMessage() {
        return this.getProblemContext() + ": " + this.getProblemDescription();
    }

    public static class InvalidValidationConfiguration
    extends ConstructionProblem {
        Validator<?> valid;

        public InvalidValidationConfiguration(Class<? extends BasePropertyGroup> group, Property<?> property, Validator<?> valid) {
            this.badPropertyCoord = new PropertyCoord(group, property);
            this.valid = valid;
        }

        public Validator<?> getValidator() {
            return this.valid;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("Has a Validator of type {} that is not configured correctly: {}", this.valid.getClass().getSimpleName(), this.valid.getInvalidSpecificationMessage());
        }
    }

    public static class InvalidDefaultValue
    extends ConstructionProblem {
        String invalidMessage;

        public InvalidDefaultValue(Class<? extends BasePropertyGroup> group, Property<?> prop, String invalidMessage) {
            this.badPropertyCoord = new PropertyCoord(group, prop);
            this.invalidMessage = invalidMessage;
        }

        public String getInvalidMessage() {
            return this.invalidMessage;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("Has a default value that does not pass validation: {}", this.invalidMessage);
        }
    }

    public static class ExportException
    extends ConstructionProblem {
        Exception exception;
        String message;

        public ExportException(Exception exception, Class<? extends BasePropertyGroup> group, String message) {
            this.exception = exception;
            this.message = message;
            this.badPropertyCoord = new PropertyCoord(group, null);
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("PropertyGroup {}", this.badPropertyCoord.getGroup().getCanonicalName());
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("An error occured while initiating the value export.  The message was: {}", this.message);
        }
    }

    public static class PropertyNotPartOfGroup
    extends ConstructionProblem {
        public PropertyNotPartOfGroup(Class<? extends BasePropertyGroup> group, Property<?> prop) {
            this.badPropertyCoord = new PropertyCoord(group, prop);
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("This property is not part of the group its is being added to.", new Object[0]);
        }
    }

    public static class SecurityException
    extends ConstructionProblem {
        Exception exception;

        public SecurityException(Exception exception, Class<? extends BasePropertyGroup> group) {
            this.exception = exception;
            this.badPropertyCoord = new PropertyCoord(group, null);
        }

        public Exception getException() {
            return this.exception;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("PropertyGroup {}", this.badPropertyCoord.getGroup().getCanonicalName());
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("A security exception was thrown while trying to read class members.  {} must read PropertyGroup class members via reflection to build Property names. To fix, ensure that all PropertyGroup members are public or turn off JVM security policies that might be preventing this.", "AndHow");
        }
    }

    public static class LoaderPropertyNotRegistered
    extends ConstructionProblem {
        Loader loader;
        Property property;

        public LoaderPropertyNotRegistered(Loader loader, Property property) {
            this.loader = loader;
            this.property = property;
        }

        public Loader getLoader() {
            return this.loader;
        }

        public Property getProperty() {
            return this.property;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("The {} loader's Property of type {}", this.loader.getClass().getCanonicalName(), this.property.getValueType().getDestinationType().getSimpleName());
        }

        @Override
        public String getProblemDescription() {
            return "This loader has a Property declared in its constructor, but that property is not added to the application configuration. Add the Property to a PropertyGroup and add the group to the configuration via builder.group(myGroup.class).";
        }
    }

    public static class DuplicateLoader
    extends ConstructionProblem {
        Loader loader;

        public DuplicateLoader(Loader loader) {
            this.loader = loader;
        }

        public Loader getLoader() {
            return this.loader;
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("Multiple loaders of type {}", this.loader.getClass().getCanonicalName());
        }

        @Override
        public String getProblemDescription() {
            return "The same Loader instance has been added multiple times. Loaders of the same type are allowed, but they must be separate instances.";
        }
    }

    public static class DuplicateProperty
    extends ConstructionProblem {
        public DuplicateProperty(Class<? extends BasePropertyGroup> refGroup, Property<?> refProperty, Class<? extends BasePropertyGroup> badGroup, Property<?> badProperty) {
            this.refPropertyCoord = new PropertyCoord(refGroup, refProperty);
            this.badPropertyCoord = new PropertyCoord(badGroup, badProperty);
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("Is the same instance as {} - The containing PropertyGroups are sharing a reference to the same Property instance.  Properties must each be independant instances because they each identify unique values.", this.refPropertyCoord.getPropName());
        }
    }

    public static class NonUniqueNames
    extends ConstructionProblem {
        String conflictName;

        public NonUniqueNames(Class<? extends BasePropertyGroup> refGroup, Property<?> refProperty, Class<? extends BasePropertyGroup> badGroup, Property<?> badProperty, String conflictName) {
            this.refPropertyCoord = new PropertyCoord(refGroup, refProperty);
            this.badPropertyCoord = new PropertyCoord(badGroup, badProperty);
            this.conflictName = conflictName;
        }

        public String getConflictName() {
            return this.conflictName;
        }

        @Override
        public String getProblemDescription() {
            return TextUtil.format("Has the name '{}' which is a name or alias in use by {}. All names must be unique and, for the BasicNamingStrategy, must be unique in a case insensitive way.", this.conflictName, this.refPropertyCoord.getPropName());
        }
    }
}

