/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.internal.ValueMapImmutable;

public abstract class ValueMapWithContextBase
implements ValueMapWithContext {
    protected final <T> T getValue(List<LoaderValues> valuesList, Property<T> prop) {
        return prop.getValueType().cast(valuesList.stream().filter(lv -> lv.isExplicitlySet(prop)).map(lv -> lv.getExplicitValue(prop)).findFirst().orElse(null));
    }

    protected final <T> T getEffectiveValue(List<LoaderValues> valuesList, Property<T> prop) {
        if (this.isPropertyPresent(valuesList, prop)) {
            return this.getValue(valuesList, prop);
        }
        return prop.getDefaultValue();
    }

    protected final boolean isPropertyPresent(List<LoaderValues> valuesList, Property<?> prop) {
        return valuesList.stream().anyMatch(pv -> pv.isExplicitlySet(prop));
    }

    protected final LoaderValues getAllValuesLoadedByLoader(List<LoaderValues> valuesList, Loader loader) {
        return valuesList.stream().filter(lv -> lv.getLoader().equals(loader)).findFirst().get();
    }

    public LoaderValues getEffectiveValuesLoadedByLoader(List<LoaderValues> valuesList, Loader loader) {
        LoaderValues allLoaderValues = this.getAllValuesLoadedByLoader(loader);
        if (allLoaderValues != null) {
            ArrayList<PropertyValue> effValues = new ArrayList<PropertyValue>(allLoaderValues.getValues());
            for (LoaderValues lvs : valuesList) {
                if (lvs.getLoader().equals(loader)) break;
                effValues.removeIf(pv -> lvs.isExplicitlySet(pv.getProperty()));
            }
            return new LoaderValues(loader, effValues, ProblemList.EMPTY_PROBLEM_LIST);
        }
        return null;
    }

    public ValueMapImmutable buildValueMapImmutable(List<LoaderValues> valuesList) {
        HashMap effValues = new HashMap();
        for (LoaderValues lvs : valuesList) {
            for (PropertyValue pv : lvs.getValues()) {
                effValues.putIfAbsent(pv.getProperty(), pv.getValue());
            }
        }
        return new ValueMapImmutable(effValues);
    }
}

