/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.yarnandtail.andhow.GroupInfo;
import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.ConstructionDefinition;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.PropertyValue;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.api.ValueMap;
import org.yarnandtail.andhow.api.ValueMapWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.load.BaseLoader;
import org.yarnandtail.andhow.property.QuotedSpacePreservingTrimmer;
import org.yarnandtail.andhow.property.StrProp;
import org.yarnandtail.andhow.sample.JndiLoaderSamplePrinter;
import org.yarnandtail.andhow.util.TextUtil;

public class JndiLoader
extends BaseLoader {
    static String JNDI_PROTOCOL_NAME = "java:";

    @Override
    public LoaderValues load(ConstructionDefinition appConfigDef, ValueMapWithContext existingValues) {
        ArrayList<String> jndiRoots = this.buildJndiRoots(existingValues);
        ArrayList<PropertyValue> values = new ArrayList<PropertyValue>();
        ProblemList<Problem> problems = new ProblemList<Problem>();
        try {
            InitialContext ctx = new InitialContext();
            ArrayList<String> propNames = new ArrayList<String>();
            for (Property<?> prop : appConfigDef.getProperties()) {
                if (appConfigDef.getNamingStrategy().isUriNameDistict(appConfigDef.getCanonicalName(prop))) {
                    propNames.add(appConfigDef.getNamingStrategy().getUriName(appConfigDef.getCanonicalName(prop)));
                }
                propNames.add(appConfigDef.getCanonicalName(prop));
                appConfigDef.getAliases(prop).stream().filter(a -> a.isIn()).forEach(a -> {
                    propNames.add(a.getActualName());
                    if (appConfigDef.getNamingStrategy().isUriNameDistict(a.getActualName())) {
                        propNames.add(appConfigDef.getNamingStrategy().getUriName(a.getActualName()));
                    }
                });
                for (String root : jndiRoots) {
                    for (String propName : propNames) {
                        try {
                            Object o = ctx.lookup(JNDI_PROTOCOL_NAME + root + propName);
                            if (o == null) continue;
                            this.attemptToAdd(appConfigDef, values, problems, prop, o);
                        }
                        catch (NameNotFoundException nameNotFoundException) {}
                    }
                }
                propNames.clear();
            }
        }
        catch (NamingException ex) {
            problems.add(new LoaderProblem.JndiContextLoaderProblem(this));
        }
        return new LoaderValues(this, values, problems);
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return false;
    }

    @Override
    public boolean isUnrecognizedPropertyNamesConsideredAProblem() {
        return false;
    }

    @Override
    public String getSpecificLoadDescription() {
        return "JNDI properties in the system-wide JNDI context";
    }

    @Override
    public Class<? extends BasePropertyGroup> getClassConfig() {
        return CONFIG.class;
    }

    @Override
    public SamplePrinter getConfigSamplePrinter() {
        return new JndiLoaderSamplePrinter();
    }

    protected ArrayList<String> buildJndiRoots(ValueMap values) {
        ArrayList<String> myJndiRoots = new ArrayList<String>();
        List<String> someRoots = this.split((String)CONFIG.STANDARD_JNDI_ROOTS.getValue(values));
        myJndiRoots.addAll(someRoots);
        String addRoots = (String)CONFIG.ADDED_JNDI_ROOTS.getValue(values);
        if (addRoots != null) {
            someRoots = this.split(addRoots);
            myJndiRoots.addAll(someRoots);
        }
        return myJndiRoots;
    }

    protected List<String> split(String rootStr) {
        if (rootStr != null) {
            QuotedSpacePreservingTrimmer trimmer = QuotedSpacePreservingTrimmer.instance();
            String[] roots = rootStr.split(",");
            for (int i = 0; i < roots.length; ++i) {
                roots[i] = trimmer.trim(roots[i]);
                if (roots[i].length() <= 0 || roots[i].endsWith("/")) continue;
                roots[i] = roots[i] + "/";
            }
            return Arrays.asList(roots);
        }
        return TextUtil.EMPTY_STRING_LIST;
    }

    @Override
    public String getLoaderType() {
        return "JNDI";
    }

    @Override
    public String getLoaderDialect() {
        return null;
    }

    @GroupInfo(name="JndiLoader Configuration", desc="Since application containers use various JNDI roots to store environment varibles, these properties allow customization. The most common roots are \"\" or \"comp/env/\". If your container uses something different, set one of these properties. All configured JNDI roots will be searched for each application property. For both properties, trailing slashes will automcatically be added, however, a leading slash is significant - is non-standard but allowed and your properties must match.")
    public static interface CONFIG
    extends BasePropertyGroup {
        public static final StrProp STANDARD_JNDI_ROOTS = ((StrProp.StrBuilder)((StrProp.StrBuilder)((StrProp.StrBuilder)StrProp.builder().defaultValue("comp/env/, \"\"")).desc("A comma separated list of standard JNDI root locations to be searched for properties. Setting this property will replace the standard list, use ADDED_JNDI_ROOTS to only add to the list. ")).helpText("The final JNDI URIs to be searched will look like this 'java:[root]/[Property Name]'")).build();
        public static final StrProp ADDED_JNDI_ROOTS = ((StrProp.StrBuilder)((StrProp.StrBuilder)StrProp.builder().desc("A comma separated list of JNDI root locations to be added to the standard list for searching. Setting this property does not affect the STANDARD_JNDI_ROOTS.")).helpText("The final JNDI URIs to be searched will look like this 'java:[root]/[Property Name]'")).build();
    }
}

